function md=bamg(md,varargin)
%BAMG - mesh generation
%
%   Usage:
%      md=bamg(md,varargin);

%process options
options=pairoptions(varargin{:});

%initialize the structures required as input of Bamg
bamg_options=struct();
bamg_geometry=struct();
bamg_mesh=struct();

% Bamg Geometry parameters {{{1
bamg_geometry.NumVertices=0;
bamg_geometry.Vertices=zeros(0,3);
bamg_geometry.NumEdges=0;
bamg_geometry.Edges=zeros(0,3);
bamg_geometry.NumCrackedEdges=0;
bamg_geometry.CrackedEdges=zeros(0,1);
bamg_geometry.hVertices=zeros(0,1);
bamg_geometry.NumSubDomains=0;
bamg_geometry.SubDomains=zeros(0,3);
if exist(options,'domain'),
	domainfile=getfieldvalueerr(options,'domain');
	if ~exist(domainfile,'file')
		error(['bamg error message: file ' domainfile ' not found ']);
	else
		domain=expread(domainfile);

		%build geometry
		count=0;

		for i=1:length(domain),

			%if current profile is closed
			if (domain(i).x(1)==domain(i).x(end) & domain(i).y(1)==domain(i).y(end)),
				nods=domain(i).nods-1; %the domain are closed 1=end;
				bamg_geometry.Vertices=[bamg_geometry.Vertices; [domain(i).x(1:nods) domain(i).y(1:nods) ones(nods,1)]];
				bamg_geometry.Edges=[bamg_geometry.Edges; [transp(count+1:count+nods) transp([count+2:count+nods count+1])  1*ones(nods,1)]];
				if i>1,
					%if closed : hole
					clockwise=-1;
					bamg_geometry.SubDomains=[2 count+1 clockwise 1];

				end

			elseif i>1
				%rift
				nods=domain(i).nods-1;
				bamg_geometry.Vertices=[bamg_geometry.Vertices; [domain(i).x(:) domain(i).y(:) ones(nods+1,1)]];
				bamg_geometry.Edges=[bamg_geometry.Edges; [transp(count+1:count+nods) transp([count+2:count+nods+1])  2*ones(nods,1)]];

			else
				error('bamg error message: the first domain should be closed');
			end
			count=count+nods;
		end
		if exist(options,'hVertices'),
			bamg_geometry.hVertices=getfieldvalueerr(options,'hVertices');
			if length(bamg_geometry.hVertices)~=nods,
				error(['hVertices option should be of size [' num2str(nods) ',1]']);
			end
		end
		bamg_geometry.NumVertices=size(bamg_geometry.Vertices,1);
		bamg_geometry.NumEdges=size(bamg_geometry.Edges,1);
		bamg_geometry.NumSubDomains=size(bamg_geometry.SubDomains,1);
	end 
end
%}}}

% Bamg Mesh parameters {{{1
bamg_mesh.NumVertices=0;
bamg_mesh.Vertices=[];
bamg_mesh.NumTriangles=0;
bamg_mesh.Triangles=[];
bamg_mesh.NumEdges=0;
bamg_mesh.Edges=zeros(0,3);
bamg_mesh.hVertices=[];
bamg_mesh.NumCrackedEdges=0;
bamg_mesh.CrackedEdges=zeros(0,2);
if (~exist(options,'domain') & md.numberofgrids~=0 & strcmpi(md.type,'2d')),
	bamg_mesh.NumVertices=md.numberofgrids;
	bamg_mesh.Vertices=[md.x md.y ones(md.numberofgrids,1)];
	bamg_mesh.NumTriangles=md.numberofelements;
	bamg_mesh.Triangles=[md.elements ones(md.numberofelements,1)];
	if exist(options,'hVertices'),
		bamg_mesh.hVertices=getfieldvalueerr(options,'hVertices');
		if length(bamg_mesh.hVertices)~=md.numberofgrids,
			error(['hVertices option should be of size [' num2str(md.numberofgrids) ',1]']);
		end
	end
	if isstruct(md.rifts)
		for i=1:length(md.rifts)
			bamg_mesh.Edges=[bamg_mesh.Edges;md.rifts(i).segments];
		end
		bamg_mesh.NumEdges=size(bamg_mesh.Edges,1);
		bamg_mesh.NumCrackedEdges=bamg_mesh.NumEdges;
		bamg_mesh.CrackedEdges=[1 2;3 4];
	end
end
%}}}

% Bamg Options {{{1
bamg_options.err=getfieldvalue(options,'err',0.01);
bamg_options.errg=getfieldvalue(options,'errg',0.1);
bamg_options.coef=getfieldvalue(options,'coef',1);
bamg_options.maxsubdiv=getfieldvalue(options,'maxsubdiv',10);
bamg_options.power=getfieldvalue(options,'power',1);
bamg_options.nbjacobi=getfieldvalue(options,'nbjacobi',1);
bamg_options.Hessiantype=getfieldvalue(options,'Hessiantype',0);
bamg_options.Metrictype=getfieldvalue(options,'Metrictype',0);
bamg_options.KeepVertices=getfieldvalue(options,'KeepVertices',1);
bamg_options.NbSmooth=getfieldvalue(options,'NbSmooth',3);
bamg_options.omega=getfieldvalue(options,'omega',1.8);
bamg_options.maxnbv=getfieldvalue(options,'maxnbv',10^6);
bamg_options.MaximalAngleOfCorner=getfieldvalue(options,'MaximalAngleOfCorner',10);
bamg_options.hmin=getfieldvalue(options,'hmin',10^-100);
bamg_options.hmax=getfieldvalue(options,'hmax',10^100);
bamg_options.anisomax=getfieldvalue(options,'anisomax',10^30);
bamg_options.gradation=getfieldvalue(options,'gradation',1.5);
bamg_options.cutoff=getfieldvalue(options,'cutoff',10^-5);
bamg_options.verbose=getfieldvalue(options,'verbose',1);
bamg_options.splitcorners=getfieldvalue(options,'splitcorners',1);
bamg_options.metric=getfieldvalue(options,'metric',[]);
bamg_options.field=getfieldvalue(options,'field',[]);
%}}}

%check bamg options
fieldsize=size(bamg_options.field);
if fieldsize(1),
	if fieldsize(1)~=md.numberofgrids,
		error(['bamg error message, ''field'' should have ' num2str(md.numberofgrids) ' lines (numberofgrids)']);
	end
	if (fieldsize(2)~=0 & length(bamg_options.err)~=fieldsize(2)),
		error(['bamg error message, ''err'' should be of length ' num2str(fieldsize(2)) ' (As many as fields)']);
	end
end


%call Bamg
[triangles vertices segments segmentsmarkers metric]=Bamg(bamg_mesh,bamg_geometry,bamg_options);

% plug results onto model
md.x=vertices(:,1);
md.y=vertices(:,2);
md.elements=triangles(:,1:3);
md.segments=segments;
md.segmentmarkers=segmentsmarkers;
md.dummy=metric;

%Fill in rest of fields:
md.type='2d';
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.gridonbed=ones(md.numberofgrids,1);
md.gridonwater=zeros(md.numberofgrids,1);
md.gridonsurface=ones(md.numberofgrids,1);
md.elementonbed=ones(md.numberofelements,1);
md.elementonsurface=ones(md.numberofelements,1);
md.gridonboundary=zeros(md.numberofgrids,1); md.gridonboundary(md.segments(:,1:2))=1;
md.counter=1;
