#!/bin/bash

#Some cleanup
rm -rf meshpart
rm -rf src 
rm -rf install 

#Create src and install directories
mkdir src install 

#Untar 
tar -xvzf meshpart-020208.tar.gz
mkdir meshpart/metis
tar -xvzf metismex-4.0.tar.gz -C meshpart/metis

#Move meshpart to src directory
mv meshpart/* src
rm -rf meshpart

#Apply patches
patch src/fiedler.m fiedler.m.patch
patch src/chaco.m chaco.m.patch
patch src/meshdemo.m meshdemo.m.patch
patch src/metis/metismex.c metismex.c.patch
patch src/chaco/mlchaco.c mlchaco.c.patch
patch src/chaco/Makefile Makefile.patch

#Nothing to build for meshpart itself

#Build metismex
cd src/metis
#proto.h in metis library is not patched, at least for metismex, so create a local version
#mex -I../../../metis/install/Lib -L../../../metis/install -lmetis -largeArrayDims metismex.c
cp ../../../metis/install/Lib/proto.h .
patch proto.h ../../proto.h.patch
mex -I. -I../../../metis/install/Lib -L../../../metis/install -lmetis -largeArrayDims metismex.c
cd ../..

#Build mlchaco
cd src/chaco
make
#Clean up, specifically the objects left in the chaco directories by mlchaco
make clean
cd ../..

