#!/bin/bash

#Some cleanup
rm -rf Chaco-2.2
rm -rf src 
rm -rf install 

#Create src and install directories
mkdir src install 

#Untar 
tar -xvzf Chaco-2.2.tar.gz

#Move chaco to src directory
mv Chaco-2.2/* src
rm -rf Chaco-2.2

#Apply patches
patch src/code/main/defs.h defs.h.patch
patch src/code/assign/assign_out.c assign_out.c.patch
patch src/code/eigen/get_extval.c get_extval.c.patch
patch src/code/klvspiff/matching.c matching.c.patch
patch src/code/misc/timing.c timing.c.patch
patch src/code/util/bail.c bail.c.patch
patch src/code/util/checkpnt.c checkpnt.c.patch
patch src/code/util/doubleout.c doubleout.c.patch
patch src/code/util/smalloc.c smalloc.c.patch
patch src/code/util/strout.c strout.c.patch
patch src/code/Makefile Makefile.patch

#Build chaco
cd src/code
make
#Clean up, so that meshpart creates its own objects for mlchaco
make clean
cd ../..

