#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "../Mesh2.h"
#include "../QuadTree.h"
#include "../SetOfE4.h"

#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#undef __FUNCT__ 
#define __FUNCT__ "Triangle"

namespace bamg {

	/*Methods*/
	/*FUNCTION Triangle::FindBoundaryEdge{{{1*/
	TriangleAdjacent Triangle::FindBoundaryEdge(int i) const{

		/*Intermediary*/
		Triangle* ttc=NULL;
		int k,j,jc;

		// call current triangle t
		Triangle* t = (Triangle*)this;

		//is the current triangle inside or outside?
		int outside=!link  ;

		// EdgesVertexTriangle[3][2] = {{1,2},{2,0},{0,1}};
		// initialize j as the first vertex of the ith edge
		j=EdgesVertexTriangle[i][0];

		//Loop over the adjacent triangle of t
		k=0;
		do{
			//keep track of outside
			int outsidep = outside;
			//increment k
			k++;
			//Get ttc, adjacent triangle of t with respect to vertex j
			ttc =  t->at[j];
			//is the current triangle inside or outside?
			outside = !ttc->link;
			//if both previous triangle are outside, return
			if (outside+outsidep == 1) return TriangleAdjacent(t,j);

			//update t and j
			t = ttc;
			//NextEdge[3] = {1,2,0};
			jc = NextEdge[t->aa[j]&3];
			j = NextEdge[jc];

			//check number of iterations
			if (k>=2000){
				throw ErrorException(__FUNCT__,exprintf("too many iteration in Triangle::FindBoundaryEdge (k>=2000)"));
			}
		} while (this!= t);
		//not found, return empty triangle
		return TriangleAdjacent(NULL,0);
	}
	/*}}}1*/
	/*FUNCTION Triangle::Echo {{{1*/

	void Triangle::Echo(void){

		int i;

		printf("Triangle:\n");
		printf("   ns pointer towards three vertices\n");
		printf("      ns[0] ns[1] ns[2] = %p %p %p\n",ns[0],ns[1],ns[2]);
		printf("   at pointer towards three adjacent triangles\n");
		printf("      at[0] at[1] at[2] = %p %p %p\n",at[0],at[1],at[2]);
		printf("   det (integer triangle determinant) = %i\n",det);
		if (link){
			printf("   link (pointer toward duplicate triangle)= %p\n",link);
		}
		else{
			printf("   color = %i\n",color);
		}

		printf("\nThree vertices:\n");
		for(i=0;i<3;i++){
			if (ns[i]){
				ns[i]->Echo();
			}
			else{
				printf("   vertex %i does not exist\n",i+1);
			}
		}

		return;
	}
	/*}}}*/

}
