function md=geography(md,iceshelfname,icesheetname)
%GEOGRAPHY - establish boundaries between grounded and floating ice.
%
%   By default, ice is considered grounded. The contour iceshelfname defines grids 
%   for which ice is floating. The contour icesheetname defines grids inside an iceshelf, 
%   that are grounded (ie: ice rises, islands, etc ...)
%   All input files are in the Argus format (extension .exp).
%
%   Usage:
%      md=geography(md,iceshelfname,icesheetname)
%
%   Examples:
%      md=geography(md,'all','');
%      md=geography(md,'Iceshelves.exp','Islands.exp');

%some checks on list of arguments
if ((nargin~=3) | (nargout~=1)),
	help geography
	error('geography error message');
end

if md.counter>=2,
	choice=input('This model already has a geometry. Are you sure you want to go ahead? (y/n)','s');
	if ~strcmp(choice,'y'), error('no geometry done ... exiting'); end
else
	if (md.counter~=1), error('geography error message: you need to run mesh.m first on this model'); end
end

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

elementoniceshelf=FlagElements(md,iceshelfname);
elementonicesheet=FlagElements(md,icesheetname);

%Because icesheet grids and elements can be included into an iceshelf, we need to update. Remember, all the previous 
%arrays come from domain outlines that can intersect one another: 
gridoniceshelf=zeros(md.numberofgrids,1);
gridonicesheet=zeros(md.numberofgrids,1);
elementoniceshelf=double((elementoniceshelf & ~elementonicesheet));
elementonicesheet=double(~elementoniceshelf);
gridoniceshelf(md.elements(find(elementoniceshelf),:))=1;
gridonicesheet(md.elements(find(elementonicesheet),:))=1;

%Return: 
md.counter=2;

md.elementoniceshelf=elementoniceshelf;
md.gridoniceshelf=gridoniceshelf;

md.elementonicesheet=elementonicesheet;
md.gridonicesheet=gridonicesheet;

md.gridonwater=zeros(md.numberofgrids,1);
md.elementonwater=zeros(md.numberofelements,1);

%Keep track of input files
if (strcmp(iceshelfname,'') | strcmp(iceshelfname,'all')),
	md.iceshelfoutline=iceshelfname;
else 
	md.iceshelfoutline=char(textread(iceshelfname,'%s','delimiter','\n'));
end
if (strcmp(icesheetname,'') | strcmp(icesheetname,'all')),
	md.icesheetoutline=icesheetname;
else 
	md.icesheetoutline=char(textread(icesheetname,'%s','delimiter','\n'));
end
