#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "../Mesh2.h"
#include "../QuadTree.h"
#include "../SetOfE4.h"

#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#undef __FUNCT__ 
#define __FUNCT__ "Triangle"

namespace bamg {

	/*Methods*/
	/*FUNCTION Triangle::FindBoundaryEdge{{{1*/
	TriangleAdjacent Triangle::FindBoundaryEdge(int i) const{
		// turn around  the vertex ns[i] also call  s
		Triangle* t = (Triangle*)this;
		Triangle* ttc=NULL;

		int k=0,j = EdgesVertexTriangle[i][0],jc;
		int exterieur  = !link  ;

		do{
			int exterieurp = exterieur;
			k++; 
			ttc =  t->at[j];
			exterieur = !ttc->link;
			if (exterieur+exterieurp == 1) 
			 return TriangleAdjacent(t,j);
			jc = NextEdge[t->aa[j]&3];
			t = ttc;
			j = NextEdge[jc];
			if (k>=2000){
				throw ErrorException(__FUNCT__,exprintf("too many iteration in Triangle::FindBoundaryEdge (k>=2000)"));
			}
		} while (this!= t); 
		return TriangleAdjacent(0,0);
	}
	/*}}}1*/
	/*FUNCTION Triangle::Echo {{{1*/

	void Triangle::Echo(void){

		int i;

		printf("Triangle:\n");
		printf("   ns pointer towards three vertices\n");
		printf("      ns[0] ns[1] ns[2] = %p %p %p\n",ns[0],ns[1],ns[2]);
		printf("   at pointer towards three adjacent triangles\n");
		printf("      at[0] at[1] at[2] = %p %p %p\n",at[0],at[1],at[2]);
		printf("   det (integer triangle determinant) = %i\n",det);
		if (link){
			printf("   link (pointer toward duplicate triangle)= %p\n",link);
		}
		else{
			printf("   color = %i\n",color);
		}

		printf("\nThree vertices:\n");
		for(i=0;i<3;i++){
			if (ns[i]){
				ns[i]->Echo();
			}
			else{
				printf("   vertex %i does not exist\n",i+1);
			}
		}

		return;
	}
	/*}}}*/

}
