/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_


#include "./Element.h"
#include "./Node.h"
#include "./Matice.h"
#include "./Matpar.h"
#include "./Numpar.h"
#include "./ParameterInputs.h"

class Tria: public Element{

	private: 

		/*ids:*/
		int id;

		/*nodes: */
		int   node_ids[3]; //node ids
		Node* nodes[3]; //node pointers
		int   node_offsets[3]; //node offsets in nodes dataset

		/*materials: */
		int   mid;
		Matice* matice; 
		int   matice_offset;
		
		int mparid;
		Matpar* matpar; 
		int   matpar_offset;

		int numparid;
		Numpar* numpar; 
		int   numpar_offset;
	
		double h[3];
		double s[3];
		double b[3];
		double k[3];
		double melting[3];
		double accumulation[3];
		double geothermalflux[3];
		int    friction_type;
		double p;
		double q;
		int    shelf;
		int    onbed;
		bool   onwater;

	public:

		Tria();
		Tria(int id,int mid,int mparid,int numparid,int node_ids[3],double h[3],double s[3],double b[3],double k[3],double melting[3],double accumulation[3],double geothermalflux[3],int friction_type,double p,double q,int shelf,bool onwater);
		~Tria();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  Configure(void* loads,void* nodes,void* materials,void* parameters);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHoriz(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticHorizFriction(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixDiagnosticSurfaceVert(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixSlopeCompute(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  GetParameterDerivativeValue(double* p, double* plist,double* xyz_list, double* gauss_l1l2l3);
		void  GetStrainRate(double* epsilon, double* velocity, double* xyz_list, double* gauss_l1l2l3);
		void  GetJacobianDeterminant2d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobianDeterminant3d(double*  Jdet, double* xyz_list,double* gauss_l1l2l3);
		void  GetB(double* B, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime(double* Bprime, double* xyz_list, double* gauss_l1l2l3);
		void  GetL(double* L, double* xyz_list, double* gauss_l1l2l3,int numdof);
		void  GetB_prog(double* B_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetBPrime_prog(double* Bprime_prog, double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctions(double* l1l2l3, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivatives(double* dh1dh3,double* xyz_list, double* gauss_l1l2l3);
		void  GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss_l1l2l3);
		void  GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss_l1l2l3);
		void  GetJacobian(double* J, double* xyz_list,double* gauss_l1l2l3);
		void  Du(Vec du_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type,char* control_type);
		void  GradjDrag(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  GradjDragStokes(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		void  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void  GradjB(Vec grad_g,void* inputs,int analysis_type,int sub_analysis_type);
		double Misfit(void* inputs,int analysis_type,int sub_analysis_type);

		void  CreatePVectorDiagnosticHoriz(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorDiagnosticBaseVert(Vec pg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorSlopeCompute( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void* GetMatPar();
		int   GetShelf();
		void  GetNodes(void** nodes);
		int   GetOnBed();

		void  GetThicknessList(double* thickness_list);
		void  GetBedList(double* bed_list);
		Object* copy();
		void  NodeConfiguration(int* tria_node_ids,Node* tria_nodes[3],int* tria_node_offsets);
		void  MaticeConfiguration(Matice* matice,int matice_offset);
		void  MatparConfiguration(Matpar* matpar,int matpar_offset);
		void  NumparConfiguration(Numpar* tria_numpar,int tria_numpar_offset);
		void  ComputePressure(Vec p_g);
		void  CreateKMatrixThermal(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixMelting(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalShelf( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreatePVectorThermalSheet( Vec pg, void* vinputs, int analysis_type,int sub_analysis_type);
		void  CreateKMatrixPrognostic(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorPrognostic(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedthickness(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedthickness(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreateKMatrixBalancedvelocities(Mat Kgg,void* vinputs,int analysis_type,int sub_analysis_type);
		void  CreatePVectorBalancedvelocities(Vec pg,void* vinputs,int analysis_type,int sub_analysis_type);
		double MassFlux(double* segment,double* ug);
		double GetArea(void);
		double GetAreaCoordinate(double x, double y, int which_one);

};
#endif  /* _TRIA_H */
