function md_list=loadmultipleresultsfromcluster(md_list)
%LOADMULTIPLERESULTSFROMCLUSTER - load multiple results of solution sequences from cluster
%
%   Usage:
%      md_list=loadresultsfromcluster(md_list);

nummodels=length(md_list.models);

%Get cluster settings
cluster=md_list.cluster;
name=md_list.name;
cluster_rc_location=which('cluster.rc');
[codepath,executionpath]=ClusterParameters(cluster,cluster_rc_location);

%Remote tar: 
disp('tarring results');
issmssh(cluster,['"cd ' executionpath '/' name ' && rm -rf file_list.txt ModelResults.tar.gz && find -iname ''*-*vs*.outbin'' > file_list.txt && tar zcvf ModelResults.tar.gz --files-from file_list.txt  && rm -rf file_list.txt "']);

%copy results from cluster to present directory
scpin(cluster, [executionpath '/' name], {'ModelResults.tar.gz'});

%untar:
!tar -zxvf ModelResults.tar.gz

%ok, go through list and load results from disk: 
for i=1:nummodels,
	%load  results for this model
	md_list.models{i}=loadresultsfromdisk(md_list.models{i},[name '-' num2str(i) 'vs' num2str(nummodels) '.outbin']);

	%post solve phase
	md_list.models{i}=postsolveparallel(md_list.models{i});
	delete([name '-' num2str(i) 'vs' num2str(nummodels) '.outbin']);
end

%erase files 
delete('ModelResults.tar.gz');
