/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	int   nods=0; //to be removed
	BamgOpts bamgopts;
	BamgMesh bamgmesh;
	BamgGeom bamggeom;

	/*Mesh inputs*/
	int     NumVerticesMesh;
	double* VerticesMesh=NULL;
	int     NumTrianglesMesh;
	double* TrianglesMesh=NULL;
	double* hVerticesMesh=NULL;

	/*Geom inputs: */
	int     NumVerticesGeom;
	double* VerticesGeom=NULL;
	int     NumEdgesGeom;
	double* EdgesGeom=NULL;
	double* hVerticesGeom=NULL;
	double  MaximalAngleOfCorner;
	int     NumSubDomainsGeom;
	double* SubDomainsGeom=NULL;

	/*Options inputs*/
	int    iso,maxnbv,verbose,splitcorners;
	double hmin,hmax,anisomax;
	double err,errg,coef;
	double power;
	int    Hessiantype,Metrictype,NbSmooth;
	int    nbjacobi,AbsError;
	double omega;
	double gradation;
	double cutoff;
	double* metric=NULL;
	double* field=NULL;
	int     numfields=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	FetchData(&NumVerticesGeom,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	bamggeom.NumVertices=NumVerticesGeom;
	FetchData(&VerticesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	bamggeom.Vertices=VerticesGeom;
	FetchData(&NumEdgesGeom,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	bamggeom.NumEdges=NumEdgesGeom;
	FetchData(&EdgesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	bamggeom.Edges=EdgesGeom;
	FetchData(&hVerticesGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	bamggeom.hVertices=hVerticesGeom;
	bamggeom.MetricVertices=NULL;
	bamggeom.h1h2VpVertices=NULL;
	bamggeom.NumTangentAtEdges=0;
	bamggeom.TangentAtEdges=NULL;
	bamggeom.NumCorners=0;
	bamggeom.Corners=NULL;
	bamggeom.NumRequiredVertices=0;
	bamggeom.RequiredVertices=NULL;
	bamggeom.NumRequiredEdges=0;
	bamggeom.RequiredEdges=NULL;
	bamggeom.NumCrackedEdges=0;
	bamggeom.CrackedEdges=NULL;
	FetchData(&NumSubDomainsGeom,mxGetField(BAMGGEOMETRY,0,"NumSubDomains"));
	bamggeom.NumSubDomains=NumSubDomainsGeom;
	FetchData(&SubDomainsGeom,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	bamggeom.SubDomains=SubDomainsGeom;

	/*create bamg mesh input*/
	FetchData(&NumVerticesMesh,mxGetField(BAMGMESH,0,"NumVertices"));
	bamgmesh.NumVertices=NumVerticesMesh;
	FetchData(&VerticesMesh,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	bamgmesh.Vertices=VerticesMesh;
	FetchData(&NumTrianglesMesh,mxGetField(BAMGMESH,0,"NumTriangles"));
	bamgmesh.NumTriangles=NumTrianglesMesh;
	FetchData(&TrianglesMesh,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	bamgmesh.Triangles=TrianglesMesh;
	FetchData(&hVerticesMesh,NULL,NULL,mxGetField(BAMGMESH,0,"hVertices"));
	bamgmesh.hVertices=hVerticesMesh;
	bamgmesh.NumQuadrilaterals=0;
	bamgmesh.Quadrilaterals=NULL;
	bamgmesh.NumVerticesOnGeometricVertex=0;
	bamgmesh.VerticesOnGeometricVertex=NULL;
	bamgmesh.NumVerticesOnGeometricEdge=0;
	bamgmesh.VerticesOnGeometricEdge=NULL;
	bamgmesh.NumEdgesOnGeometricEdge=0;
	bamgmesh.EdgesOnGeometricEdge=NULL;
	bamgmesh.NumEdges=0;
	bamgmesh.Edges=NULL;
	bamgmesh.NumCrackedEdges=0;
	bamgmesh.CrackedEdges=NULL;
	bamgmesh.NumSubDomains=0;
	bamgmesh.SubDomains=NULL;
	bamgmesh.NumSubDomainsFromGeom=0;
	bamgmesh.SubDomainsFromGeom=NULL;

	/*create bamg options input*/
	FetchData(&iso,mxGetField(BAMGOPTIONS,0,"iso"));
	bamgopts.iso=iso;
	FetchData(&err,mxGetField(BAMGOPTIONS,0,"err"));
	bamgopts.err=err;
	FetchData(&errg,mxGetField(BAMGOPTIONS,0,"errg"));
	bamgopts.errg=errg;
	FetchData(&coef,mxGetField(BAMGOPTIONS,0,"coef"));
	bamgopts.coef=coef;
	FetchData(&Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	bamgopts.Hessiantype=Hessiantype;
	FetchData(&Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	bamgopts.Metrictype=Metrictype;
	FetchData(&power,mxGetField(BAMGOPTIONS,0,"power"));
	bamgopts.power=power;
	FetchData(&nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	bamgopts.nbjacobi=nbjacobi;
	FetchData(&AbsError,mxGetField(BAMGOPTIONS,0,"AbsError"));
	bamgopts.AbsError=AbsError;
	FetchData(&NbSmooth,mxGetField(BAMGOPTIONS,0,"NbSmooth"));
	bamgopts.NbSmooth=NbSmooth;
	FetchData(&omega,mxGetField(BAMGOPTIONS,0,"omega"));
	bamgopts.omega=omega;
	FetchData(&maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	bamgopts.maxnbv=maxnbv;
	FetchData(&hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	bamgopts.hmin=hmin;
	FetchData(&hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	bamgopts.hmax=hmax;
	FetchData(&anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	bamgopts.anisomax=anisomax;
	FetchData(&gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	bamgopts.gradation=gradation;
	FetchData(&cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	bamgopts.cutoff=cutoff;
	FetchData(&verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	bamgopts.verbose=verbose;
	FetchData(&splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	bamgopts.splitcorners=splitcorners;
	FetchData(&MaximalAngleOfCorner,mxGetField(BAMGOPTIONS,0,"MaximalAngleOfCorner"));
	bamgopts.MaximalAngleOfCorner=MaximalAngleOfCorner;
	FetchData(&metric,NULL,NULL,mxGetField(BAMGOPTIONS,0,"metric"));
	bamgopts.metric=metric;
	FetchData(&field,NULL,&numfields,mxGetField(BAMGOPTIONS,0,"field"));
	bamgopts.numfields=numfields;
	bamgopts.field=field;

	/*!Generate internal degree of freedom numbers: */
	nods=bamgmesh.NumVertices;
	Bamgx(&bamgmesh,&bamggeom,&bamgopts);

	/*write output datasets: */
	WriteData(TRIANGLESOUT,bamgmesh.Triangles,bamgmesh.NumTriangles,4);
	WriteData(VERTICESOUT,bamgmesh.Vertices,bamgmesh.NumVertices,3);
	WriteData(METRICOUT,bamgopts.metric,nods,3);

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,x,y]=%s(bamgmesh,bamggeom,bamgoptions,nbv);\n",__FUNCT__);
	_printf_("\n");
}
