function []=part_hist(maptab,wgt);

imin=min(maptab(:,2));
imax=max(maptab(:,2));

part=zeros(imax-imin+1,2);

for i=imin:imax
    ind=find(maptab(:,2) == i);
    part(i-imin+1,1)=length(ind);
    if exist('wgt','var')
        part(i-imin+1,2)=sum(wgt(ind));
    else
        part(i-imin+1,2)=part(i-imin+1,1);
    end
end

figure
subplot(2,1,1)
bar(imin:imax,part(:,1));
xlim([imin imax])
title('Number of Elements in Each Partition')

subplot(2,1,2)
bar(imin:imax,part(:,2));
xlim([imin imax])
title('Weight of Elements in Each Partition')

end
