function md=LaunchMultipleQueueJobgemini(cluster,name,executionpath)
%LAUNCHMULTIPLEQUEUEJOBGEMINI - Launch multiple queueing script on Gemini cluster
%
%   Usage:
%      LaunchMultipleQueueJobgemini(cluster,name,executionpath)


%first, check we have the binary file and the queueing script
if ~exist([ name '.queue'],'file'),
	error('LaunchMultipleQueueJobgemini error message: queueing script issing, cannot go forward');
end

if ~exist('ModelList.tar.gz','file'),
	error('LaunchMultipleQueueJobgemini error message: inputs models file missing, cannot go forward');
end

%upload both files to cluster
disp('uploading input file,  queueing script and variables script');
eval(['!scp ModelList.tar.gz ' name '.queue '  cluster ':' executionpath]);

disp('launching solution sequence on remote cluster');
issmssh(cluster,['"cd ' executionpath ' && source ' name '.queue "']);
