function mds=solve(mds,varargin)
%SOLVE - apply solution sequence for  a list of models. Used in batch mode.
%
%   Usage:
%      mds=solve(mds,varargin)
%      where varargin is a lit of paired arguments. 
%      arguments can be: 'analysis_type': 'diagnostic','thermal','prognostic','transient'
%      arguments can be: 'sub_analysis_type': 'transient','steady','' (default if empty = 'steady')
%
%   Examples:
%      mds=solve(mds,'analysis_type','diagnostic');
%      mds=solve(mds,'analysis_type','thermal','sub_analysis_type','transient');
%      mds=solve(mds,'analysis_type','thermal','sub_analysis_type','steady');
%      mds=solve(mds,'analysis_type','thermal');

%recover options
options=pairoptions(varargin{:});

%add default options
options=process_solve_options(options);

%length of list
nummodels=length(mds.models);

%name of queue: to make it unique, add a time stamp
name=[mds.name '-' datestr(now,1) '-' datestr(now,'HH-MM-SS') ];

%name of cluster will be first name of list
cluster=mds.cluster;

%Figure out parameters for this particular cluster
cluster_rc_location=which('cluster.rc');
[codepath,executionpath]=ClusterParameters(cluster,cluster_rc_location);

%solve in batch mode: 
for i=1:nummodels,

	%model
	md=mds.models{i};
	
	%recover some fields
	md.analysis_type=options.analysis_type;
	md.sub_analysis_type=options.sub_analysis_type;

	md.name=[name '-' num2str(i) 'vs' num2str(nummodels)];
	md.time=mds.time;
	md.queue=mds.queue;
	md.cluster=mds.cluster;
	if ~isnan(mds.np),
		md.np=mds.np;
	end

	%call solve in batch mode:
	md=solve(md,varargin{:},'batch','yes','directory',name);

	%feed back
	mds.models{i}=md;
end

%now, tar all the files and then erase them.
eval(['!find -iname ''' name '-*'' > file_list.txt']);
!tar zcvf ModelList.tar.gz --files-from file_list.txt
!rm -rf *.bin *.queue file_list.txt

%still have to build a launching script.
BuildMultipleQueueingScript(cluster,name,executionpath,codepath);

%launch jobs on remote cluster
LaunchMultipleQueueJob(cluster,name,executionpath);

%erase files: 
delete([name '.queue']);
delete('ModelList.tar.gz');
