#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"

namespace bamg {

	const int MaxDeep = 30;
	typedef  long  IntQuad;
	const IntQuad MaxISize = ( 1L << MaxDeep); //long int 1, bitwise operation: 8L = 00001000 << 2L -> 00100000 shifted left by 2
	class Triangles;
	class Vertex;
	class QuadTree {
		public:
			class QuadTreeBox { 
				public:
					long n; 
					union{
						//contains only one object form the list (either Vertex or QuadTreeBox)
						// if n < 4 => Vertex else =>  QuadTreeBox;
						QuadTreeBox* b[4];
						Vertex* v[4];
					};
			}; // end class
			class StorageQuadTreeBox {
				public:
					QuadTreeBox *b,*bc,*be;
					long len;
					StorageQuadTreeBox* n; // next StorageQuadTreeBox
					StorageQuadTreeBox(long ,StorageQuadTreeBox* =NULL);
					~StorageQuadTreeBox() {
						if(n) delete n;
						delete [] b;
					}
					long  SizeOf() const {return len*sizeof(QuadTreeBox)+sizeof(StorageQuadTreeBox)+ (n?n->SizeOf():0);}
			}; // end class
			StorageQuadTreeBox* sb;
			long  lenStorageQuadTreeBox;

		public:
			QuadTreeBox* root;
			Triangles* th;
			long NbQuadTreeBox,NbVertices;
			long NbQuadTreeBoxSearch,NbVerticesSearch;
			Vertex* NearestVertex(Icoor1 i,Icoor1 j);
			Vertex*  NearestVertexWithNormal(Icoor1 i,Icoor1 j);
			Vertex* ToClose(Vertex & ,Real8 ,Icoor1,Icoor1);
			long SizeOf() const {return sizeof(QuadTree)+sb->SizeOf();}
			void  Add( Vertex & w);
			QuadTreeBox* NewQuadTreeBox(){
				if(! (sb->bc<sb->be)) sb=new StorageQuadTreeBox(lenStorageQuadTreeBox,sb);
				if (!sb || (sb->bc->n != 0)){throw ErrorException(__FUNCT__,exprintf("!sb || (sb->bc->n != 0)"));}
				NbQuadTreeBox++;
				return sb->bc++;
			}
			~QuadTree();
			QuadTree(Triangles * t,long nbv=-1);
			QuadTree();
	};
}
