function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

if ~md.qmu_analysis,

	%initialize md.results if not a structure yet
	if ~isstruct(md.results),
		md.results=struct();
	end

	%load results onto model
	structure=parseresultsfromdisk(filename);
	md.results.(structure.analysis_type)=structure;

	%recover analysis_type from results
	md.analysis_type=structure(1).analysis_type;
	if isscalar(md.sub_analysis_type),
		md.sub_analysis_type=AnalysisTypeFromEnum(md.sub_analysis_type);
	end

	%Check result is consistent, only if it exists
	disp(sprintf('%s\n','checking result consistency'));
	if ~isresultconsistent(md,structure(1).analysis_type),
		%it would be very cruel to use an error, it would kill the computed results (although they are not consistent...)
		disp('!! results not consistent correct the model !!') 
	end

%post processes qmu results if necessary
else

	md.analysis_type    =AnalysisTypeFromEnum(md.analysis_type);
	md.sub_analysis_type=AnalysisTypeFromEnum(md.sub_analysis_type);
	md=postqmu(md);
	cd ..

end
