%Test of a bump

loadmodel diagstokes
mdc=mds;

%initialize model with Stokes model
md=model;
md=mesh(md,'DomainOutline.exp',2000);
md=meshexprefine(md,'ContourBump.exp',500);
md=geography(md,'','');
md=parameterize(md,'Bump.par');
md=extrude(md,8,4);
md.pressure=zeros(md.numberofgrids,1);
md.vx=zeros(md.numberofgrids,1);
md.vy=zeros(md.numberofgrids,1);
md.vz=zeros(md.numberofgrids,1);
md=setelementstype(md,'pattyn','all','stokes','all');

%Initialize the CM with average value of vx and vy
md.vx_obs=mdc.results.diagnostic.vx;
md.vy_obs=mdc.results.diagnostic.vy;
md.vel_obs=mdc.results.diagnostic.vel;

md.nsteps=5;
md.fit=2*ones(5,1);
md.optscal=1000*ones(5,1);
md.maxiter=20*ones(5,1);
%compute solution
md=solve(md,'analysis_type','control');

save step1 md
md.drag=md.results.control.parameter;

md=solve(md,'analysis_type','control');
save step2 md

md.drag=md.results.control.parameter;
md.fit=0*md.fit;
save step3 md

%save model stokes
mds=md;
save modelstokes mds
error

%now run a control method on macayeal
md=model;
md=mesh(md,'DomainOutline.exp',2000);
md=meshexprefine(md,'ContourBump.exp',500);
md=geography(md,'','');
md=parameterize(md,'Bump.par');
md.pressure=zeros(md.numberofgrids,1);
md.vx=zeros(md.numberofgrids,1);
md.vy=zeros(md.numberofgrids,1);
md.vz=zeros(md.numberofgrids,1);
md=setelementstype(md,'macayeal','all');

%Initialize the CM with average value of vx and vy
md.vx_obs=DepthAverage(mdc,mdc.results.diagnostic.vx);
md.vy_obs=DepthAverage(mdc,mdc.results.diagnostic.vy);
md.vel_obs=DepthAverage(mdc,mdc.results.diagnostic.vel);

%Compute the CM
md=solve(md,'analysis_type','control')

%save model macayeal
mdm=md;
save modelmacayeal mdm

%now run a control method on pattyn
md=model;
md=mesh(md,'DomainOutline.exp',2000);
md=meshexprefine(md,'ContourBump.exp',500);
md=geography(md,'','');
md=parameterize(md,'Bump.par');
md=extrude(md,8,4);
md.pressure=zeros(md.numberofgrids,1);
md.vx=zeros(md.numberofgrids,1);
md.vy=zeros(md.numberofgrids,1);
md.vz=zeros(md.numberofgrids,1);
md=setelementstype(md,'pattyn','all');

%Initialize the CM
md.vx_obs=mdc.results.diagnostic.vx;
md.vy_obs=mdc.results.diagnostic.vy;
md.vel_obs=mdc.results.diagnostic.vel;

%Compute the CM
md=solve(md,'analysis_type','control')

%save model pattyn
mdp=md;
save modelpattyn mdp
