function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

if ~md.qmu_analysis,
	%load result onto model
	if ~isstruct(md.results),
		md.results=struct();
	end

	structure=parseresultsfromdisk(filename);
	md.results.(structure.analysis_type)=structure;

	%Check result is consistent, only if it exists
	disp(sprintf('%s\n','checking result consistency'));
	if ~isresultconsistent(md,structure(1).analysis_type),
		%it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
		disp('!! results not consistent correct the model !!') 
	end
end

%recover analysis_type from results
md.analysis_type=structure(1).analysis_type;
if isscalar(md.sub_analysis_type),
	md.sub_analysis_type=AnalysisTypeFromEnum(md.sub_analysis_type);
end

%post processes qmu results if necessary
if md.qmu_analysis,
	md=postqmu(md);
	cd ..
end
