function md_list=multisolve(md_list,varargin)
%SOLVE - apply solution sequence for  a list of models. Used in batch mode.
%
%   Usage:
%      md_list=solve(md_list,varargin)
%      where varargin is a lit of paired arguments. 
%      arguments can be: 'analysis_type': 'diagnostic','thermal','prognostic','transient'
%      arguments can be: 'sub_analysis_type': 'transient','steady','' (default if empty = 'steady')
%
%   Examples:
%      md_list=solve(md_list,'analysis_type','diagnostic');
%      md_list=solve(md_list,'analysis_type','thermal','sub_analysis_type','transient');
%      md_list=solve(md_list,'analysis_type','thermal','sub_analysis_type','steady');
%      md_list=solve(md_list,'analysis_type','thermal');

%recover options
options=pairoptions(varargin{:});

%add default options
options=process_solve_options(options);

%length of list
nummodels=length(md_list);

%name of queue will be first name of list
name=md_list{1}.name;

%name of cluster will be first name of list
cluster=md_list{1}.cluster;

%Figure out parameters for this particular cluster
cluster_rc_location=which('cluster.rc');
[codepath,executionpath]=ClusterParameters(cluster,cluster_rc_location);

%solve in batch mode: 
for i=1:nummodels,

	%model
	md=md_list{i};
	
	%recover some fields
	md.analysis_type=options.analysis_type;
	md.sub_analysis_type=options.sub_analysis_type;

	md.name=[name '_' num2str(i) 'vs' num2str(nummodels)];

	%call solve in batch mode:
	md=solve(md,varargin{:},'batch','yes');

	%feed back
	md_list{i}=md;
end

%now, tar all the files and then erase them.
!find -iname '*_*vs*' > file_list.txt
!tar zcvf ModelList.tar.gz --files-from file_list.txt
!rm -rf *_*vs* file_list.txt

%still have to build a launching script.
BuildMultipleQueueingScript(cluster,name,executionpath,codepath);

%launch jobs on remote cluster
LaunchMultipleQueueJob(cluster,name,executionpath);

%erase files: 
delete([name '.queue']);
delete('ModelList.tar.gz');
