function md=loadresultsfromcluster(md)
%LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster
%
%   Usage:
%      md=loadresultsfromcluster(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%What packages are we picking up from remote cluster
packages={[md.name '.outlog'],[md.name '.errlog']};
if md.qmu_analysis,
	packages{end+1}=[md.name '.qmu.err'];
	packages{end+1}=[md.name '.qmu.out'];
	if md.qmu_params.tabular_graphics_data==true,
		packages{end+1}='dakota_tabular.dat'; 
	end
else
	packages{end+1}=[md.name '.outbin'];
end

%copy files from cluster to present directory
scpin(md.cluster, executionpath, packages);

%read log files onto  fields
md.errlog=char(textread([md.name '.errlog'],'%s','delimiter','\n'));
md.outlog=char(textread([md.name '.outlog'],'%s','delimiter','\n'));
if ~isempty(md.errlog),
	disp(['loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields']);
end

%If we are here, no errors in the solution sequence, call loadresultsfromdisk.
md=loadresultsfromdisk(md,[md.name '.outbin']);

%erase the log and output files
delete([md.name '.outlog']);
delete([md.name '.errlog']);
delete([md.name '.outbin']);

%erase input file if run was carried out on same platform.
hostname=oshostname();
if strcmpi(hostname,md.cluster),
	delete([md.name '.lock']);
	delete([md.name '.bin']);
	delete([md.name '.queue']);
end

%post solve phase
md=postsolveparallel(md);
