function md=radarpower(md,hemisphere,xlim,ylim,highres)
%RADARPOWER - overlay a power radar image on an existing mesh
%
%   This routine will overlay a power radar image on an existing mesh.
%   The power amplitude will be output to vel for now.
%   In the future, think about a field to hold this value.
%
%   Usage:
%      md=radarpower(md,hemisphere,xlim,ylim,highres)

global ISSM_DIR
global MODELDATA

%if MODELDATA has not been initialized (ie: empty), use default path.
if isempty(MODELDATA), MODELDATA='/u/astrid-r1b/larour/ModelData'; end

%find gdal coordinates
x0=min(xlim);
x1=max(xlim);

y0=min(ylim);
y1=max(ylim);

%Get path  to gdal binaries
path_gdal=[ISSM_DIR '/externalpackages/gdal/install/bin/'];

%Was gdal compiled? 
if ~exist([path_gdal 'gdal_translate']),
	error(['radarpower error message: GDAL library needs to be compiled to use this routine. Compile GDAL in ' ISSM_DIR '/externalpackages/gdal to use this routine.']);
end

%the geotiff image is either 200m or 1km accuracy. 
if strcmpi(hemisphere,'n'),
	if ~exist([MODELDATA '/MOG/mog150_greenland_map.jpg']),
		error(['radarpower error message: file ' MODELDATA '/MOG/mog150_greenland_map.jpg not found. Check MODELDATA variable..']);
	end
	jpgim=[MODELDATA '/MOG/mog150_greenland_map.jpg'];
	geom=load([MODELDATA '/MOG/mog150_greenland_map.jpgw'],'ascii');
	sizex=floor((x1-x0)/geom(1)); % x posting
	sizey=floor((y1-y0)/geom(4)); % y posting
	topleftx=floor((x0-geom(5))/geom(1)); % x min
	toplefty=floor((geom(6)-y1)/geom(4)); % y max

	%Read and crop file
	im=imread(jpgim);
	save temp im geom
	im=im(toplefty:toplefty+sizey,topleftx:topleftx+sizex);
	md.sarpwr=double(flipud(im));
	md.sarxm=(x0:(x1-x0)/(size(md.sarpwr,2)-1):x1);
	md.sarym=(y0:(y1-y0)/(size(md.sarpwr,1)-1):y1);

else
	if highres,
		if ~exist([MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif']),
			error(['radarpower error message: file ' MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif not found. Check MODELDATA variable..']);
		end
		geotiff_name=[MODELDATA '/MosaicTiffRsat/amm125m_v2_200m.tif'];
	else
		if ~exist([MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif']),
			error(['radarpower error message: file ' MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif not found. Check MODELDATA variable..']);
		end
		geotiff_name=[MODELDATA '/MosaicTiffRsat/amm125m_v2_1km.tif'];
	end

	%Name of image
	inputname='./temp.tif';
	system([path_gdal 'gdal_translate -quiet -projwin ' num2str(x0) ' ' num2str(y1) ' ' num2str(x1) ' ' num2str(y0) ' ' geotiff_name ' ' inputname ]);

	%Read in temp.tif:
	md.sarpwr=double(flipud(imread('temp.tif','TIFF')));
	md.sarxm=(x0:(x1-x0)/(size(md.sarpwr,2)-1):x1);
	md.sarym=(y0:(y1-y0)/(size(md.sarpwr,1)-1):y1);

	%Erase image
	system('rm -rf ./temp.tif');

end
