function md_list=multisolve(md_list,varargin)
%SOLVE - apply solution sequence for  a list of models. Used in batch mode.
%
%   Usage:
%      md_list=solve(md_list,varargin)
%      where varargin is a lit of paired arguments. 
%      arguments can be: 'analysis_type': 'diagnostic','thermal','prognostic','transient'
%      arguments can be: 'sub_analysis_type': 'transient','steady','' (default if empty = 'steady')
%
%   Examples:
%      md_list=solve(md_list,'analysis_type','diagnostic');
%      md_list=solve(md_list,'analysis_type','thermal','sub_analysis_type','transient');
%      md_list=solve(md_list,'analysis_type','thermal','sub_analysis_type','steady');
%      md_list=solve(md_list,'analysis_type','thermal');

%length of list
nummodels=length(md_list);

%solve in batch mode: 
for i=1:nummodels,

	%model
	md=md_list{i};
	md.name=[md.name '_' num2str(i) 'vs' num2str(nummodels)];

	%call solve in batch mode:
	md=solve(md,varargin{:},'batch','yes');
end

%now, tar all the files and then erase them.
!find -iname '*_*vs*' > file_list.txt
!tar zcvf ModelList.tar.gz --files-from file_list.txt
!rm -rf *_*vs* file_list.txt

%still have to build a launching script.

%now, send to cluster and solve
