function BuildQueueingScriptGeneric(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGENERIC - ...
%
%   Usage:
%      BuildQueueingScriptGeneric(md,executionpath,codepath)

global ISSM_DIR

%Open queuing script file 
scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptGenericerror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'rm -rf %s/%s.lock\n',executionpath,md.name);

if md.mem_debug==0,
fprintf(fid,'mpirun -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',md.np,codepath,AnalysisTypeFromEnum(md.analysis_type),executionpath,md.name,md.name,md.name,md.name,md.name);
else
fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full %s/%s.exe %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',[ISSM_DIR '/externalpackages/valgrind/install/lib/libmpidebug.so'],md.np,[ISSM_DIR '/externalpackages/valgrind/install/bin/valgrind'],codepath,AnalysisTypeFromEnum(md.analysis_type),executionpath,md.name,md.name,md.name,md.name,md.name);
end

fclose(fid);
