function applyoptions(md,data,options)
%APPLYOPTIONS - apply the options to current plot
%
%   Usage:
%      applyoptions(md,data,options)
%
%   See also: PLOTMODEL, PARSE_OPTIONS

%fontsize
fontsize=getfieldvalue(options,'fontsize',14);

%fontweight
fontweight=getfieldvalue(options,'fontweight','normal');

%title
if exist(options,'title')
	titlevalue=getfieldvalue(options,'title');
	if iscell(titlevalue),
		title(titlevalue,'FontSize',fontsize,'FontWeight',fontweight);
	else
		if ~isnan(titlevalue),
			title(titlevalue,'FontSize',fontsize,'FontWeight',fontweight);
		end
	end
end

%xlabel
if exist(options,'xlabel');
	xlabel(getfieldvalue(options,'xlabel'),'FontSize',fontsize,'FontWeight',fontweight);
end

%ylabel
if exist(options,'ylabel');
	ylabel(getfieldvalue(options,'ylabel'),'FontSize',fontsize,'FontWeight',fontweight);
end

%zlabel
if exist(options,'zlabel');
	zlabel(getfieldvalue(options,'zlabel'),'FontSize',fontsize,'FontWeight',fontweight);
end

%view 
if strcmpi(md.type,'3d') & ~exist(options,'layer'),
	view(getfieldvalue(options,'view',3));
else
	view(getfieldvalue(options,'view',2));
end

%latlon
%Must be done here so that it uses the same xlim and ylim as plot_overlay
%these are changed by axis that follows
if exist(options,'latlon')
	latlonoverlay(options);
end

%axis
set(gca,'FontSize',fontsize);
if exist(options,'axis')
	eval(['axis ' getfieldvalue(options,'axis')]);
else
	if (strcmpi(md.type,'2d') | exist(options,'layer')),
		axis tight equal;
	else
		axis auto tight
	end
end

%xlim
if exist(options,'xlim');
	xlim(getfieldvalue(options,'xlim'));
end

%ylim
if exist(options,'ylim');
	ylim(getfieldvalue(options,'ylim'));
end

%zlim
if exist(options,'zlim');
	zlim(getfieldvalue(options,'zlim'));
end

%Basinzoom
if exist(options,'basin');
	basinzoom(getfieldvalue(options,'basin'),getfieldvalue(options,'unit',1));
end

%Caxis
if exist(options,'caxis'),
	if exist(options,'log'),
		logvalue=getfieldvalue(options,'log');
		if any(getfieldvalue(options,'caxis')<=0),
			error('applyoptions error message: negative log values when trying to apply caxis option');
		end
		caxis(log(getfieldvalue(options,'caxis'))/log(logvalue));
	else
		caxis(getfieldvalue(options,'caxis'));
	end
end

%shading
if exist(options,'shading'),
	shading(getfieldvalue(options,'shading'));
end

%grid
if exist(options,'grid'),
	if strcmpi(getfieldvalue(options,'grid'),'on'),
		grid on;
	end
end

%colormap
if exist(options,'colormap'),
	h=colormap(getfieldvalue(options,'colormap'));
end

%wrapping
if exist(options,'wrapping'),
	if ~exist(options,'colormap'),
		h=jet;
	end
	colormap(repmat(h,getfieldvalue(options,'wrapping',1),1));
end

%colorbar
if getfieldvalue(options,'colorbar',1)==1,
	if exist(options,'colorbarcornerposition'),
		c=colorbar(getfieldvalue(options,'colorbarcornerposition'));
	else 
		c=colorbar;
	end
	set(c,'FontSize',fontsize);
	if exist(options,'wrapping')
		lim=get(c,'Ylim');
		lim=[lim(1) lim(1)+(lim(2)-lim(1))/getfieldvalue(options,'wrapping')];
		set(c,'Ylim',lim);
	end
	if exist(options,'colorbarpos'),
		set(c,'Position',getfieldvalue(options,'colorbarpos'));
	end
	if exist(options,'log'),
		logvalue=getfieldvalue(options,'log');

		scalestring=get(c,'YTickLabel');
		scalevalues=get(c,'YTick');
		scaleminmax=caxis;
		numvalues=length(scalevalues);

		scalestring=[];
		for i=1:numvalues,
			fraction=(scalevalues(i)-scaleminmax(1))/(scaleminmax(2)-scaleminmax(1));
			scalevalues(i)=round_ice(logvalue^scalevalues(i),2);
			scalestring=[scalestring; sprintf('%8.4g',scalevalues(i))];
		end
		set(c,'YTickLabel',scalestring);
		set(c,'FontSize',fontsize);
	end
	if exist(options,'colorbartitle'),
		backup=gca;
		axes(c);lab=ylabel(getfieldvalue(options,'colorbartitle'));
		set(lab,'Rotation',getfieldvalue(options,'colorbartitlerotation',-90));
		set(lab,'VerticalAlignment','bottom');
		axes(backup);
	end
%colorbar OFF
elseif getfieldvalue(options,'colorbar',1)==0,
	colorbar('off');
else
	%do nothing
end

%area
if exist(options,'area'),
	antzoom(getfieldvalue(options,'area'));
end

%expdisp
filename=(getfieldvalue(options,'expdisp'));
style=(getfieldvalue(options,'expstyle'));
for i=1:length(getfieldvalue(options,'expdisp')),
	filenamei=filename{i};
	stylei=style{i};
	expdisp(filenamei,gcf,stylei,getfieldvalue(options,'linewidth',1),getfieldvalue(options,'unit',1));
end

%text (default value is empty, not NaN...)
if exist(options,'text');
	textstring=getfieldvalue(options,'text');
	textweight=getfieldvalue(options,'textweight');
	textsize=getfieldvalue(options,'textsize');
	textcolor=getfieldvalue(options,'textcolor');
	textposition=getfieldvalue(options,'textposition');
	for i=1:length(getfieldvalue(options,'text'));
		textstringi=textstring{i};
		textweighti=textweight{i};
		textsizei=textsize{i};
		textcolori=textcolor{i};
		textpositioni=textposition{i};
		text(textpositioni(1),textpositioni(2),textstringi,'FontSize',textsizei,'FontWeight',textweighti,'Color',textcolori);
	end
end

%north arrow
if exist(options,'northarrow'),
	northarrow(getfieldvalue(options,'northarrow'));
end

%Scale ruler
if exist(options,'scaleruler'),
	scaleruler(getfieldvalue(options,'scaleruler'));
end

%streamliness
if exist(options,'streamlines'),
	plot_streamlines(md,options);
end

%contours
if exist(options,'contourlevels'),
	plot_contour(md,data,options);
end

%axes position
if exist(options,'axesPosition')
	set(gca,'Position',getfieldvalue(options,'axesPosition'));
end
