#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "../Mesh2.h"
#include "../QuadTree.h"
#include "../SetOfE4.h"

#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#undef __FUNCT__ 
#define __FUNCT__ "ListofIntersectionTriangles"

namespace bamg {

	/*Methods*/
	/*FUNCTION ListofIntersectionTriangles::SplitEdge{{{1*/
	void ListofIntersectionTriangles::SplitEdge(const Triangles & Bh, const R2 &A,const R2  &B,int nbegin) {
		Triangle *tbegin, *t;

		long int verbosity=2;
		Icoor2 deta[3], deti,detj;
		Real8 ba[3];
		int nbt =0,ifirst=-1,ilast;
		int i0,i1,i2;
		int ocut,i,j,k=-1;
		//  int OnAVertices =0;
		Icoor2 dt[3];
		I2 a = Bh.toI2(A) ,b= Bh.toI2(B);// compute  the Icoor a,b
		I2 vi,vj;  
		int iedge =-1;// not a edge

		if(nbegin)  {// optimisation 
			// we suppose  knowing the starting  triangle
			t=tbegin=lIntTria[ilast=(Size-1)].t;
			if (tbegin->det>=0) 
			 ifirst = ilast;}  
		else {// not optimisation 
			init();
			t=tbegin = Bh.FindTriangleContening(a,deta);
			if( t->det>=0)
			 ilast=NewItem(t,Real8(deta[0])/t->det,Real8(deta[1])/t->det,Real8(deta[2])/t->det);
			else 
			  {// find the nearest boundary edge  of the vertex A
				// find a edge or such normal projection a the edge IJ is on the edge
				//   <=> IJ.IA >=0 && IJ.AJ >=0
				ilast=ifirst;
				double ba,bb;
				TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
				Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
				NewItem(A,Metric(ba,v0,bb,v1));
				t=edge;
				// test if the point b is in the same side
				if (det(v0.i,v1.i,b)>=0) {
					TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
					Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
					NewItem(A,Metric(ba,v0,bb,v1));
					return;
				}
			  } // find the nearest boundary edge  of the vertex A
		} // end not optimisation 
		if (t->det<0) {  // outside departure
			while (t->det <0) { // intersection boundary edge and a,b,
				k=(*t)(0) ?  ((  (*t)(1) ? ( (*t)(2) ? -1 : 2) : 1  )) : 0;
				if (k<0){
					throw ErrorException(__FUNCT__,exprintf("k<0"));
				}
				ocut = OppositeEdge[k];
				i=VerticesOfTriangularEdge[ocut][0];
				j=VerticesOfTriangularEdge[ocut][1];
				vi=(*t)[i];
				vj=(*t)[j];
				deti = bamg::det(a,b,vi);
				detj = bamg::det(a,b,vj);
				if (deti>0) // go to  i direction on gamma
				 ocut = PreviousEdge[ocut];      
				else if (detj<=0) // go to j direction on gamma
				 ocut = NextEdge[ocut];         
				TriangleAdjacent tadj =t->Adj(ocut);
				t = tadj;
				iedge= tadj; 
				if (t == tbegin) { // 
					double ba,bb;
					long int verbosity=2;
					TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
					Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
					NewItem(A,Metric(ba,v0,bb,v1));
					return;
				}
			} //  end while (t->det <0)
			// theoriticaly we have: deti =<0 and detj>0

			// computation of barycentric coor
			// test if the point b is on size on t
			// we revert vi,vj because vi,vj is def in Adj triangle
			if ( det(vi,vj,b)>=0) {
				t=tbegin;
				Real8 ba,bb;
				TriangleAdjacent edge=CloseBoundaryEdge(b,t,ba,bb);
				NewItem(B,Metric(ba,*edge.EdgeVertex(0),bb,*edge.EdgeVertex(1)));
				return;
			}
			else
			  {
				k = OppositeVertex[iedge];
				i=VerticesOfTriangularEdge[iedge][0];
				j=VerticesOfTriangularEdge[iedge][1];
				Real8 dij = detj-deti;
				if (i+j+k != 0 + 1 +2){
					throw ErrorException(__FUNCT__,exprintf("i+j+k != 0 + 1 +2"));
				}
				ba[j] =  detj/dij;
				ba[i] = -deti/dij;
				ba[k] = 0;
				ilast=NewItem(t,ba[0],ba[1],ba[2]); }
		}  //  outside departure



		// recherche the intersection of [a,b] with Bh Mesh.
		// we know  a triangle ta contening the vertex a
		// we have 2 case for intersection [a,b] with a edge [A,B] of Bh
		// 1) the intersection point is in ]A,B[
		// 2)                        is A or B
		// first version --- 
		for (;;) {
			//    t->Draw();
			if (iedge < 0) {
				i0 =0;i1=1;i2=2;
				dt[0] =bamg::det(a,b,(*t)[0]);
				dt[1] =bamg::det(a,b,(*t)[1]);
				dt[2] =bamg::det(a,b,(*t)[2]);}
			else {
				i2 = iedge;
				i0 = NextEdge[i2];
				i1 = NextEdge[i0]; 
				dt[VerticesOfTriangularEdge[iedge][0]] = detj;// we revert i,j because
				dt[VerticesOfTriangularEdge[iedge][1]] = deti;// we take the Triangle by the other side
				dt[iedge] = det(a,b,(*t)[OppositeVertex[iedge]]);}

				// so we have just to see the transition from - to + of the det0..2 on edge of t
				// because we are going from a to b
				if       ((dt[i=VerticesOfTriangularEdge[i0][0]] <  0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] > 0))
				 ocut =i0;
				else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] <  0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] >  0))
				 ocut =i1;
				else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] <  0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] >  0))
				 ocut =i2;
				else if   ((dt[i=VerticesOfTriangularEdge[i0][0]] == 0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] >  0))
				 ocut =i0;
				else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] == 0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] >  0))
				 ocut =i1;
				else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] == 0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] >  0))
				 ocut =i2;
				else if   ((dt[i=VerticesOfTriangularEdge[i0][0]] <  0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] == 0))
				 ocut =i0;
				else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] <  0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] == 0))
				 ocut =i1;
				else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] <  0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] == 0))
				 ocut =i2;
				else { //  On a edge (2 zero)
					k =0;
					if (dt[0]) ocut=0,k++; 
					if (dt[1]) ocut=1,k++; 
					if (dt[2]) ocut=2,k++;
					if(k == 1) {
						if (dt[ocut] >0) // triangle upper AB
						 ocut = NextEdge[ocut];
						i= VerticesOfTriangularEdge[ocut][0];
						j= VerticesOfTriangularEdge[ocut][1];
					}
					else {
						throw ErrorException(__FUNCT__,exprintf("Bug Split Edge"));
					}
				}

						k = OppositeVertex[ocut];

						Icoor2 detbij = bamg::det((*t)[i],(*t)[j],b);


						if (detbij >= 0) { //we find the triangle contening b
							dt[0]=bamg::det((*t)[1],(*t)[2],b);
							dt[1]=bamg::det((*t)[2],(*t)[0],b);
							dt[2]=bamg::det((*t)[0],(*t)[1],b);
							Real8 dd = t->det;
							NewItem(t,dt[0]/dd,dt[1]/dd,dt[2]/dd);      
							return ;}
						else { // next triangle by  adjacent by edge ocut 
							deti = dt[i];
							detj = dt[j];
							Real4 dij = detj-deti;
							ba[i] =  detj/dij;
							ba[j] = -deti/dij;
							ba[3-i-j ] = 0;
							ilast=NewItem(t, ba[0],ba[1],ba[2]);      

							TriangleAdjacent ta =t->Adj(ocut);
							t = ta;
							iedge= ta; 
							if (t->det <= 0)  {
								double ba,bb;
								TriangleAdjacent edge=CloseBoundaryEdge(b,t,ba,bb);
								NewItem(B,Metric(ba,*edge.EdgeVertex(0),bb,*edge.EdgeVertex(1)));
								return;
							}
						}// we  go outside of omega 
		} // for(;;)
	}
	/*}}}1*/
	/*FUNCTION ListofIntersectionTriangles::NewItem(Triangle * tt,Real8 disp('ok0');,Real8 disp('ok1');,Real8 d2) {{{1*/
	int  ListofIntersectionTriangles::NewItem(Triangle * tt,Real8 d0,Real8 d1,Real8 d2) { 
		register int n;
		R2 x(0,0);
		if ( d0) x =      (*tt)[0].r * d0;
		if ( d1) x = x +  (*tt)[1].r * d1;
		if ( d2) x = x +  (*tt)[2].r * d2;
		// newer add same point 
		if(!Size ||  Norme2_2(lIntTria[Size-1].x-x)) {
			if (Size==MaxSize) ReShape();
			lIntTria[Size].t=tt;
			lIntTria[Size].bary[0]=d0;
			lIntTria[Size].bary[1]=d1;
			lIntTria[Size].bary[2]=d2;
			lIntTria[Size].x = x;
			Metric m0,m1,m2;
			register Vertex * v;
			if ((v=(*tt)(0))) m0    = v->m;
			if ((v=(*tt)(1))) m1    = v->m;
			if ((v=(*tt)(2))) m2    = v->m;
			lIntTria[Size].m =  Metric(lIntTria[Size].bary,m0,m1,m2);
			n=Size++;}
		else n=Size-1;
		return n;
	}
	/*}}}1*/
	/*FUNCTION ListofIntersectionTriangles::NewItem(R2 A,const Metric & mm){{{1*/
	int ListofIntersectionTriangles::NewItem(R2 A,const Metric & mm) {
		register int n;
		if(!Size ||  Norme2_2(lIntTria[Size-1].x-A)) {
			if (Size==MaxSize) ReShape();
			lIntTria[Size].t=0;
			lIntTria[Size].x=A;
			lIntTria[Size].m=mm;
			n=Size++;
		}
		else  n=Size-1;
		return  n; 
	}
	/*}}}1*/
	/*FUNCTION ListofIntersectionTriangles::Length{{{1*/
	Real8  ListofIntersectionTriangles::Length(){
		if (Size<=0){
			throw ErrorException(__FUNCT__,exprintf("Size<=0"));
		}
		// computation of the length      
		R2 C;
		Metric Mx,My;
		int ii,jj;
		R2 x,y,xy;

		SegInterpolation *SegI=lSegsI;
		SegI=lSegsI;
		lSegsI[NbSeg].last=Size;// improvement 

		int EndSeg=Size;

		y = lIntTria[0].x;
		Real8 sxy, s = 0;
		lIntTria[0].s =0;
		SegI->lBegin=s;

		for (jj=0,ii=1;ii<Size;jj=ii++) {  
			// seg jj,ii
			x=y;
			y = lIntTria[ii].x;
			xy = y-x;
			Mx = lIntTria[ii].m;
			My = lIntTria[jj].m;
			sxy =  LengthInterpole(Mx,My,xy);
			s += sxy;
			lIntTria[ii].s = s;
			if (ii == EndSeg) 
			 SegI->lEnd=s,
				SegI++,
				EndSeg=SegI->last,
				SegI->lBegin=s;

		  }
		len = s;
		SegI->lEnd=s;

		return s;
	}
	/*}}}1*/
	/*FUNCTION ListofIntersectionTriangles::NewPoints{{{1*/
	Int4 ListofIntersectionTriangles::NewPoints(Vertex * vertices,Int4 & nbv,Int4  nbvx){
		long int verbosity=0;


		const Int4 nbvold = nbv;
		Real8 s = Length();
		if (s <  1.5 ) return 0;
		//////////////////////   
		int ii = 1 ;
		R2 y,x;
		Metric My,Mx ;
		Real8 sx =0,sy;
		int nbi = Max(2,(int) (s+0.5));
		Real8 sint = s/nbi;
		Real8 si = sint;

		int EndSeg=Size;
		SegInterpolation *SegI=0;
		if (NbSeg) 
		 SegI=lSegsI,EndSeg=SegI->last;

		for (int k=1;k<nbi;k++)
		  {
			while ((ii < Size) && ( lIntTria[ii].s <= si )) 
			 if (ii++ == EndSeg) 
			  SegI++,EndSeg=SegI->last;

			int ii1=ii-1;
			x  =lIntTria[ii1].x;
			sx =lIntTria[ii1].s;
			Metric Mx=lIntTria[ii1].m;
			y  =lIntTria[ii].x;
			sy =lIntTria[ii].s;
			Metric My=lIntTria[ii].m;
			Real8 lxy = sy-sx;
			Real8 cy = abscisseInterpole(Mx,My,y-x,(si-sx)/lxy);

			R2 C;
			Real8 cx = 1-cy;
			C = SegI ? SegI->F(si): x * cx + y *cy;

			si += sint;
			if ( nbv<nbvx) {
				vertices[nbv].r = C;
				vertices[nbv++].m = Metric(cx,lIntTria[ii-1].m,cy,lIntTria[ii].m);
			}
			else return nbv-nbvold;
		  }
		return nbv-nbvold;
	}
	/*}}}1*/

}
