#include <iostream> 

#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"
#include "../meshtype.h"
#include "../SetOfE4.h"

#undef __FUNCT__ 
#define __FUNCT__ "SetOfEdges4"

using namespace std;
namespace bamg {

	/*Constructor*/
	/*FUNCTION  SetOfEdges4::SetOfEdges4(Int4 mmx,Int4 nnx){{{1*/
	SetOfEdges4::SetOfEdges4(Int4 mmx,Int4 nnx){
		nx=nnx;
		nbax=mmx;
		NbOfEdges = 0;
		tete= new Int4 [nx];
		Int4 i=nx;
		while (i--)
		 tete[i] = -1;// vide 
		Edges =new Int4Edge[nbax];
	}
	/*}}}1*/

	/*Methods*/ 
	/*FUNCTION  SetOfEdges4::find {{{1*/
	Int4 SetOfEdges4::find(Int4 ii,Int4 jj) { 
		if (tete == 0 ) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::find no more tete de liste (?)"));
		}
		Int4 n = tete[ Abs( ii ) % nx ];

		while (n >= 0) 
		 if (ii == Edges[n].i && jj == Edges[n].j) return n;
		 else n = Edges[n].next;
		return -1; //do not exist, return -1
	}
	/*}}}1*/
	/*FUNCTION  SetOfEdges4::add{{{1*/
	Int4 SetOfEdges4::add(Int4 ii,Int4 jj) {
		if (tete == 0 ) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::add no more tete de liste (?)"));
		}
		Int4 h;
		Int4 n = tete[ h = Abs( ii ) % nx ];
		while (n >= 0) 
		 if (ii == Edges[n].i && jj == Edges[n].j)
		  return n;
		 else n = Edges[n].next;
		if (nbax <=NbOfEdges ) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::add overflow: NbOfEdges=%i > nbax=%i",NbOfEdges,nbax));
		}

		Edges[NbOfEdges].i=ii;
		Edges[NbOfEdges].j=jj;
		Edges[NbOfEdges].next= tete[h];
		tete[h] = NbOfEdges;
		return NbOfEdges ++;
	}
	/*}}}1*/

}
