function scaleruler(structure)
%SCALERULER - overlay a scale ruler on current plot
%
%   Usage:
%      scaleruler(structure)

%Go through structure and fill missing arguments
if length(structure)~=5
	error('plotmodel error message: bad number of input arguments for scaleruler: [x0 y0 length thickness numberofticks]');
end

%retrieve north arrow parameters
x0=structure(1);
y0=structure(2);
lengthscale=structure(3);
widthscale=structure(4);
numberofticks=structure(5);

%initialize some coordinates
unitlength=lengthscale/(numberofticks -1);
flag=-1;

Bd=[x0 y0];
Bu=[x0 y0+widthscale];
Tick=0;

%Text
xt=Bu(1);
yt=Bu(2)+2*widthscale;
text(xt,yt,num2str(Tick),'FontSize',13,'FontWeight','b');

%loope over the patches
for i=1:numberofticks-1,
	Au=Bu;
	Ad=Bd;
	Bu=[Au(1)+unitlength Ad(2)+widthscale];
	Bd=[Ad(1)+unitlength Ad(2)];
	Tick=Tick+unitlength;

	%pathes
	if flag==-1
		p=patch([Ad(1) Bd(1) Bu(1) Au(1)],[Ad(2) Bd(2) Bu(2) Au(2)],'Black','FaceAlpha',0.5);
	else
		p=patch([Ad(1) Bd(1) Bu(1) Au(1)],[Ad(2) Bd(2) Bu(2) Au(2)],'White','FaceAlpha',0.3);
	end

	%flip flag
	flag=-flag;

	%Text
	xt=Bu(1);
	yt=Bu(2)+2*widthscale;
	if i~=numberofticks-1,
		text(xt,yt,num2str(round_ice(Tick/1000,3)),'FontSize',13,'FontWeight','b');
	end
end
text(xt,yt,[num2str(round_ice(Tick/1000,3)) ' km'],'FontSize',13,'FontWeight','b');
