function projected_vector=project3d(md3d,vector2d,type,varargin);
%PROJECT3D - vertically project a vector from 2d mesh
%
%   vertically project a vector from 2d mesh (split in noncoll and coll areas) into a 3d mesh.
%   This vector can be a grid vector of size (md3d.numberofgrids2d,N/A) or an 
%   element vector of size (md3d.numberofelements2d,N/A). 
%   type is 'element' or 'node'. layer an optional layer number where vector 
%   should keep its values. If not specified, all layers adopt the value of the 
%   2d vector.
%
%   Usage:
%      extruded_vector=project3d(md3d,vector2d,type,layer);

if nargin==4,
	layer=varargin{1};
	if ((layer<1) || (layer>md3d.numlayers)),
		error(['project3d error message: layer shoud be between 1 and ' num2str(md3d.numlayers)]);
	end
else
	layer=0;
end

if strcmpi(type,'node'),

	projected_vector=zeros(md3d.numberofgrids,size(vector2d,2));
	
	if layer==0,
		for i=1:md3d.numlayers,
			projected_vector(((i-1)*md3d.numberofgrids2d+1):(i*md3d.numberofgrids2d),:)=vector2d;
		end
	else
		projected_vector(((layer-1)*md3d.numberofgrids2d+1):(layer*md3d.numberofgrids2d),:)=vector2d;
	end
else

	projected_vector=zeros(md3d.numberofelements,size(vector2d,2));

	if layer==0,
		for i=1:(md3d.numlayers-1),
			projected_vector( ((i-1)*md3d.numberofelements2d+1):(i*md3d.numberofelements2d),:)=vector2d;
		end

	else
		projected_vector( ((layer-1)*md3d.numberofelements2d+1):(layer*md3d.numberofelements2d),:)=vector2d;
	end
end
