#include <cstdio>
#include <string.h>
#include <cmath>
#include <time.h>
#include <iostream>

#include "../Mesh2.h"
#include "../QuadTree.h"
#include "../SetOfE4.h"

using namespace std;

namespace bamg {

	/*Constructor/Destructor*/

	/*Others*/
	/*FUNCTION GeometricalEdge::R1tg{{{1*/
	Real8 GeometricalEdge::R1tg(Real8 theta,R2 & t) const // 1/R of radius of cuvature
	  { R2 A=v[0]->r,B=v[1]->r;
		Real8 dca,dcb,dcta,dctb;
		Real8 ddca,ddcb,ddcta,ddctb;
		// Real8 t1 = 1 -theta;
		// Real8 t1t1 = t1*t1;
		Real8 tt = theta*theta;
		assert( theta >=0);
		assert( theta <=1);
		if (TgA()) 
		 if (TgB()) // interpolation d'hermite
			{ //cb =  theta*theta*(3-2*theta);
			 dcb = 6*theta*(1-theta);
			 ddcb = 6*(1-2*theta);
			 //ca =  1-cb;     
			 dca = -dcb;
			 ddca = -ddcb;

			 // cta = (1-theta)*(1-theta)*theta;
			 dcta =  (3*theta - 4)*theta + 1;
			 ddcta=6*theta-4;

			 //ctb = (theta-1)*theta*theta ;
			 dctb = 3*tt - 2*theta;
			 ddctb = 6*theta-2;
			}
		 else { // 1-t*t, t-t*t, t*t
			 Real8 t = theta;
			 // cb = t*t;
			 dcb = 2*t;
			 ddcb = 2;
			 //ca = 1-cb;
			 dca = -dcb;
			 ddca = -2;
			 // cta= t-cb;
			 dcta = 1-dcb;
			 ddcta = -ddcb;
			 // ctb =0;
			 dctb=0;    
			 ddctb=0;    
		 }    
		else
		 if (TgB()){
			 Real8 t = 1-theta;
			 //ca = t*t;
			 dca = -2*t;
			 ddca = 2;
			 //cb = 1-ca;
			 dcb = -dca;
			 ddcb = -2;
			 //ctb= -t+ca;
			 dctb = 1+dca;
			 ddctb= ddca;
			 //cta=0;    
			 dcta =0;
			 ddcta =0;
		 }
		 else {t=B-A;return 0;} // lagrange P1
		R2 d =  A*dca + B*dcb + tg[0]* dcta + tg[1] * dctb;

		R2 dd =  A*ddca + B*ddcb + tg[0]* ddcta + tg[1] * ddctb;
		Real8 d2=(d,d);
		Real8 sd2 = sqrt(d2);
		t=d;
		if(d2>1.0e-20) {t/=sd2;return Abs(Det(d,dd))/(d2*sd2);}
		else return 0;
	  }
	/*}}}1*/
	/*FUNCTION GeometricalEdge::F{{{1*/
	R2 GeometricalEdge::F(Real8 theta) const // parametrization of the curve edge
	  { R2 A=v[0]->r,B=v[1]->r;
		Real8 ca,cb,cta,ctb;
		assert( theta >=-1e-12);
		assert( theta <=1+1e-12);
		if (TgA()) 
		 if (TgB()) // interpolation d'hermite
			{ cb =  theta*theta*(3-2*theta);
			 ca =  1-cb;     
			 cta = (1-theta)*(1-theta)*theta;
			 ctb = (theta-1)*theta*theta ;
			 //  if(ref==4 || ref==5)
			 //  cout << " FFF " << tg[0] << tg[1] << A << B << " => " << A*ca + B*cb + tg[0]* cta + tg[1] * ctb << endl;
			}
		 else { // 1-t*t, t-t*t, t*t
			 Real8 t = theta;
			 cb = t*t;
			 ca = 1-cb;
			 cta= t-cb;
			 ctb=0;    
		 }    
		else
		 if (TgB()){
			 Real8 t = 1-theta;
			 ca = t*t;
			 cb = 1-ca;
			 ctb= -t+ca;
			 cta=0;    
		 }
		 else {
			 ca =(1-theta),cb = theta,cta=ctb=0; // lagrange P1
		 }
		return A*ca + B*cb + tg[0]* cta + tg[1] * ctb;
	  }
	/*}}}1*/

}
