// -*- Mode : c++ -*-
//
// SUMMARY  :      
// USAGE    :        
// ORG      : 
// AUTHOR   : Frederic Hecht
// E-MAIL   : hecht@ann.jussieu.fr
//

/*

   This file is part of Freefem++

   Freefem++ is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1 of the License, or
   (at your option) any later version.

   Freefem++  is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with Freefem++; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   */
extern bool withrgraphique;

#include "../shared/shared.h"
#include <stdio.h>
#include <string.h>
#include <math.h> 
#include <time.h>
#include <iostream>

using namespace std; 

#include "Mesh2.h"
#include "QuadTree.h"
#include "SetOfE4.h"

namespace bamg {

	int  Triangles::counter = 0;

	Triangles * CurrentTh =0;

	int hinterpole=1;

	int  ForDebugging = 0;
	const Direction NoDirOfSearch = Direction();
#ifndef NDEBUG 
	inline void MyAssert(int i,char*ex,char * file,long line) 
	{
		if( i) {
			cerr << "Error Assert:" << ex << " in " << file << " line: " << line << endl;
#ifdef  NOTFREEFEM
			exit(1); 
#else
			throw(ErrorExec("exit",1000));
#endif
		}
	}
#endif

	Int4 AGoodNumberPrimeWith(Int4 n)
	{
		const Int4 BigPrimeNumber[] ={ 567890359L,
			567890431L,  567890437L,  567890461L,  567890471L,
			567890483L,  567890489L,  567890497L,  567890507L,
			567890591L,  567890599L,  567890621L,  567890629L , 0};

		Int4 o = 0;
		Int4 pi = BigPrimeNumber[1];
		for (int i=0; BigPrimeNumber[i]; i++) {
			Int4 r = BigPrimeNumber[i] % n;
			Int4 oo = Min(Min(r,n-r),Min(Abs(n-2*r),Abs(n-3*r)));
			if ( o < oo) 
				o=oo,pi=BigPrimeNumber[i];}
			//  cout << " AGoodNumberPrimeWith " << n << " " <<pi << " "<< o << endl;
			return pi; 
	}

	class Triangles;
	void MeshError(int Err,Triangles *Th){ 
		cerr << " Fatal error in the meshgenerator " << Err << endl ;
#ifdef  NOTFREEFEM
		exit(1); 
#else
		throw(ErrorMesh("Bamg",Err,Th));
#endif
	}

	ostream& operator <<(ostream& f, const  Triangle & ta)
	{
		if(CurrentTh)
			f << "[" << CurrentTh->Number(ta) << "::" 
				<<  CurrentTh->Number(ta.ns[0]) << "," 
				<<  CurrentTh->Number(ta.ns[1]) << "," 
				<<  CurrentTh->Number(ta.ns[2]) << "," 
				<< "{" <<  CurrentTh->Number(ta.at[0]) << " " << ta.aa[0] << "} " 
				<< "{" <<  CurrentTh->Number(ta.at[1]) << " " << ta.aa[1] << "} " 
				<< "{" <<  CurrentTh->Number(ta.at[2]) << " " << ta.aa[2] << "} " 
				<< "]" ;
		else
			f << "[" 
				<< ta.ns[0] << "," 
				<< ta.ns[1] << "," 
				<< ta.ns[2] << "," 
				<< "{" << ta.at[0] << " " << ta.aa[0] << "} " 
				<< "{" << ta.at[1] << " " << ta.aa[1] << "} " 
				<< "{" << ta.at[2] << " " << ta.aa[2] << "} " 
				<< "]" ;
		return f;}

		void  swap(Triangle *t1,Int1 a1,
				Triangle *t2,Int1 a2,
				Vertex *s1,Vertex *s2,Icoor2 det1,Icoor2 det2)
		{ // swap 
			// --------------------------------------------------------------
			// Int1 a2=aa[a];// les 2 numero de l arete dans les 2 triangles
			//                               
			//               sb                     sb    
			//             / | \                   /   \                      !
			//         as1/  |  \                 /a2   \                     !
			//           /   |   \               /    t2 \                    !
			//       s1 /t1  | t2 \s2  -->   s1 /___as2___\s2                 !
			//          \  a1|a2  /             \   as1   /  
			//           \   |   /               \ t1    /   
			//            \  |  / as2             \   a1/    
			//             \ | /                   \   /     
			//              sa                       sa   
			//  -------------------------------------------------------------
			int as1 = NextEdge[a1];
			int as2 = NextEdge[a2];
			int ap1 = PreviousEdge[a1];
			int ap2 = PreviousEdge[a2];
			(*t1)(VerticesOfTriangularEdge[a1][1]) = s2 ; // avant sb
			(*t2)(VerticesOfTriangularEdge[a2][1]) = s1  ; // avant sa
			// mise a jour des 2 adjacences externes 
			TriangleAdjacent taas1 = t1->Adj(as1),
							 taas2 = t2->Adj(as2),
							 tas1(t1,as1), tas2(t2,as2),
							 ta1(t1,a1),ta2(t2,a2);
			// externe haut gauche
			taas1.SetAdj2(ta2, taas1.GetAllFlag_UnSwap());
			// externe bas droite
			taas2.SetAdj2(ta1, taas2.GetAllFlag_UnSwap());
			// remove the Mark  UnMarkSwap 
			t1->SetUnMarkUnSwap(ap1);
			t2->SetUnMarkUnSwap(ap2);
			// interne 
			tas1.SetAdj2(tas2);

			t1->det = det1;
			t2->det = det2;

			t1->SetTriangleContainingTheVertex();
			t2->SetTriangleContainingTheVertex();
		} // end swap 





		Int4 FindTriangle(Triangles &Th, Real8 x, Real8 y, double* a,int & inside)
		{
			CurrentTh=&Th;
			assert(&Th);
			I2 I = Th.toI2(R2(Min(Max(Th.pmin.x,x),Th.pmax.x),Min(Max(Th.pmin.y,y),Th.pmax.y))); 
			Icoor2 dete[3];
			Triangle & tb = *Th.FindTriangleContening(I,dete);

			if  (tb.link) 
			{ // internal point in a true triangles
				a[0]= (Real8) dete[0]/ tb.det;
				a[1]= (Real8) dete[1] / tb.det;
				a[2] = (Real8) dete[2] / tb.det;
				inside = 1;	 
				return Th.Number(tb);
			} 
			else 
			{
				inside = 0; 
				double aa,bb;
				TriangleAdjacent  ta=CloseBoundaryEdgeV2(I,&tb,aa,bb);	 
				int k = ta;
				Triangle * tc = ta;
				if (!tc->link) 
				{ ta = ta.Adj();
					tc=ta;
					k = ta;
					Exchange(aa,bb);
					assert(tc->link);
				}
				a[VerticesOfTriangularEdge[k][0]] = aa;
				a[VerticesOfTriangularEdge[k][1]] = bb;
				a[OppositeVertex[k]] = 1- aa -bb;
				return Th.Number(tc);
			}
		}


		TriangleAdjacent CloseBoundaryEdge(I2 A,Triangle *t, double &a,double &b) {
			// 
			//  cout << " - ";   	 
			int k=(*t)(0) ?  ((  (*t)(1) ? ( (*t)(2) ? -1 : 2) : 1  )) : 0;
			int dir=0;
			assert(k>=0);
			int kkk=0;  
			Icoor2 IJ_IA,IJ_AJ;
			TriangleAdjacent edge(t,OppositeEdge[k]);          
			for (;;edge = dir >0 ? Next(Adj(Next(edge))) : Previous(Adj(Previous(edge)))) 
			{  

				assert(kkk++<1000);      
				Vertex  &vI =  *edge.EdgeVertex(0);
				Vertex  &vJ =  *edge.EdgeVertex(1);
				I2 I=vI, J=vJ, IJ= J-I;
				IJ_IA = (IJ ,(A-I));
				//   cout << A << vI.i << vJ.i << edge << " " <<  IJ_IA << " dir " << dir <<endl;
				if (IJ_IA<0) {
					if (dir>0) {a=1;b=0;return edge;}// change of signe => I
					else {dir=-1;
						continue;}};// go in direction i 
						IJ_AJ = (IJ ,(J-A));
						if (IJ_AJ<0) {
							if(dir<0)  {a=0;b=1;return edge;}            
							else {dir = 1;
								continue;}}// go in direction j
								double IJ2 = IJ_IA + IJ_AJ;
								assert(IJ2);
								a= IJ_AJ/IJ2;
								b= IJ_IA/IJ2;
								//    cout<< "CloseBoundaryEdge a = " << a << " b= " << b << endl;
								return edge;
			} 
		}

		TriangleAdjacent Triangle::FindBoundaryEdge(int i) const
		{
			// turn around  the vertex ns[i] also call  s
			Triangle   *t = (Triangle *) this , *ttc;
			int k=0,j = EdgesVertexTriangle[i][0],jc;
			int exterieur  = !link  ;

			do 
			{
				int exterieurp = exterieur;
				k++; 
				ttc =  t->at[j];
				exterieur = !ttc->link;
				if (exterieur+exterieurp == 1) 
					return TriangleAdjacent(t,j);
				jc = NextEdge[t->aa[j]&3];
				t = ttc;
				j = NextEdge[jc];
				assert(k<2000);
			} while ( (this!= t)); 
			return TriangleAdjacent(0,0);

		}


		TriangleAdjacent CloseBoundaryEdgeV2(I2 C,Triangle *t, double &a,double &b) 
		{ 
			// walk around the vertex 
			// version 2 for remove the probleme if we fill the hole
			//int bug=1;
			//  Triangle *torigine = t;
			// restart:
			//   int dir=0;
			assert(t->link == 0);
			// to have a starting edges 
			// try the 3 edge bourna-- in case of internal hole 
			// and choice  the best 
			// 
			// 
			// the probleme is in case of  the fine and long internal hole
			// for exemple neart the training edge of a wing
			// 
			Vertex * s=0,*s1=0, *s0=0;
			Icoor2 imax = MaxICoor22;
			Icoor2 l0 = imax,l1 = imax;
			double dd2 =  imax;// infinity
			TriangleAdjacent er; 
			int  cas=-2;
			for (int j=0;j<3;j++)
			{ 
				TriangleAdjacent ta=t->FindBoundaryEdge(j);
				if  (! (Triangle *) ta) continue;
				s0 = ta.EdgeVertex(0);
				s1 = ta.EdgeVertex(1);
				I2 A = * s0;
				I2 B = *ta.EdgeVertex(1);
				I2 AB = B-A,AC=C-A,BC=B-C;
				Icoor2  ACAC = (AC,AC), BCBC = (BC,BC);
				Icoor2  AB2  =   Norme2_2(AB); //  ||AB||^2
				Icoor2  ABAC  =   (AB,AC);         //  AB.AC|

				double d2;
				if ( ABAC < 0 )   // DIST A
				{
					if ( (d2=(double) ACAC)  <  dd2) 
					{
						//  cout << " A "  << d2  << " " <<  dd2;
						er = ta;
						l0 = ACAC;
						l1 = BCBC;
						cas = 0;
						s = s0;
					}
				}
				else if (ABAC > AB2)  // DIST B
				{
					if ( (d2=(double) BCBC)  <  dd2) 
					{
						// cout << " B "  << d2  << " " <<  dd2;
						dd2 = d2;
						er = Adj(ta); // other direction
						l0 = BCBC;
						l1 = ACAC;
						cas = 1;
						s = s1;
					}
				}
				else  // DIST AB
				{ 

					double det_2 =  (double) Det(AB,AC); 
					det_2 *= det_2; // square of area*2 of triangle ABC
					d2 = det_2/ (double) AB2; // hauteur^2 in C of of triangle ABC      
					//	  cout << " AB " << d2 << " " << dd2 
					//      << " " << CurrentTh->Number(ta.EdgeVertex(0)) 
					//     << " " << CurrentTh->Number(ta.EdgeVertex(1)) << " " ;

					if (d2 < dd2) 
					{
						dd2 = d2;
						er = ta;
						l0 = (AC,AC);
						l1 = (BC,BC);
						s = 0;
						cas = -1;
						//	 cout << " ABAC " <<  ABAC << " ABAC " << ABAC
						//	      << " AB2 " << AB2 << endl;
						b = ((double) ABAC/(double) AB2);
						a = 1 - b;
					}
				}
			}
			assert(cas !=-2);
			// l1 = ||C s1||  , l0 = ||C s0||
			// where s0,s1 are the vertex of the edge er

			if ( s) 
			{ 
				t=er;
				TriangleAdjacent edge(er); 

				int kkk=0;  
				int linkp = t->link == 0;

				Triangle * tt=t=edge=Adj(Previous(edge));
				//  cout << CurrentTh->Number(t) << " " << linkp << endl;
				do  {  // loop around vertex s

					assert(edge.EdgeVertex(0)==s && kkk++<10000);

					int link = tt->link == 0;
					//	 cout << CurrentTh->Number(tt) << " " << link << " " << CurrentTh->Number(s) 
					//	      << " " << CurrentTh->Number(er.EdgeVertex(0)) 
					//	      << " " << CurrentTh->Number(er.EdgeVertex(1)) 
					//	      << " " << CurrentTh->Number(edge.EdgeVertex(0)) 
					//	      << " " << CurrentTh->Number(edge.EdgeVertex(1)) 
					//	      <<  endl;
					if ((link + linkp) == 1) 
					{ // a boundary edge 
						Vertex * st = edge.EdgeVertex(1);
						I2 I=*st;
						Icoor2  ll = Norme2_2 (C-I);
						if (ll < l1) {  // the other vertex is neart 
							s1=st;
							l1=ll;
							er = edge;
							if(ll<l0) { // change of direction --
								s1=s;
								l1=l0;
								s=st;
								l0=ll;
								t=tt;
								edge=Adj(edge);
								link=linkp;
								er = edge;
							}
						}
					}

					linkp=link;
					edge=Adj(Previous(edge));
					tt = edge;
				} while (t!=tt);

				assert((Triangle *) er);
				I2 A((I2)*er.EdgeVertex(0));
				I2 B((I2)*er.EdgeVertex(1));
				I2 AB=B-A,AC=C-A,CB=B-C;
				double aa =  (double) (AB,AC);
				double bb =  (double) (AB,CB);
				//  cout << " " << aa << " " << bb 
				//    << " " << CurrentTh->Number(er.EdgeVertex(0)) 
				//	    << " " << CurrentTh->Number(er.EdgeVertex(1)) ;
				if (aa<0)       a=1,b=0;
				else if(bb<0)   a=0,b=1;
				else  
				{
					a  = bb/(aa+bb);
					b  = aa/(aa+bb);
				}
			}

			//   cout <<" return= " <<  CurrentTh->Number(er.EdgeVertex(0)) << " " 
			//	<<  CurrentTh->Number(er.EdgeVertex(1)) << " " << a 
			//	<< " " << b <<" " << l0 << " " <<l1 <<endl;
			return er;
		} 


		void ListofIntersectionTriangles::SplitEdge(const Triangles & Bh,
				const R2 &A,const R2  &B,int nbegin)
		{ //  SplitEdge
			//  if(SHOW)  cout << " splitedge " << A << B << " " <<  nbegin << endl;
			Triangle *tbegin, *t;

			long int verbosity=2;
			Icoor2 deta[3], deti,detj;
			Real8 ba[3];
			int nbt =0,ifirst=-1,ilast;
			int i0,i1,i2;
			int ocut,i,j,k=-1;
			//  int OnAVertices =0;
			Icoor2 dt[3];
			I2 a = Bh.toI2(A) ,b= Bh.toI2(B);// compute  the Icoor a,b
			I2 vi,vj;  
			int iedge =-1;// not a edge

			if(nbegin)  {// optimisation 
				// we suppose  knowing the starting  triangle
				t=tbegin=lIntTria[ilast=(Size-1)].t;
				if (tbegin->det>=0) 
					ifirst = ilast;}  
			else {// not optimisation 
				init();
				t=tbegin = Bh.FindTriangleContening(a,deta);
				//    if(SHOW) cout <<t << " " << Real8(deta[0])/t->det<< " " << Real8(deta[1])/t->det
				//		  << " " << Real8(deta[2])/t->det << endl;
				if( t->det>=0)
					ilast=NewItem(t,Real8(deta[0])/t->det,Real8(deta[1])/t->det,Real8(deta[2])/t->det);
				else 
				{// find the nearest boundary edge  of the vertex A
					// find a edge or such normal projection a the edge IJ is on the edge
					//   <=> IJ.IA >=0 && IJ.AJ >=0
					ilast=ifirst;
					double ba,bb;
					TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
					Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
					NewItem(A,Metric(ba,v0,bb,v1));
					t=edge;
					// test if the point b is in the same side
					if (det(v0.i,v1.i,b)>=0) {
						//cout << " All the edge " << A << B << endl;
						TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
						Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
						NewItem(A,Metric(ba,v0,bb,v1));
						return;
					}
				} // find the nearest boundary edge  of the vertex A
			} // end not optimisation 
			if (t->det<0) {  // outside departure
				while (t->det <0) { // intersection boundary edge and a,b,
					k=(*t)(0) ?  ((  (*t)(1) ? ( (*t)(2) ? -1 : 2) : 1  )) : 0;
					assert(k>=0);
					ocut = OppositeEdge[k];
					i=VerticesOfTriangularEdge[ocut][0];
					j=VerticesOfTriangularEdge[ocut][1];
					vi=(*t)[i];
					vj=(*t)[j];
					deti = bamg::det(a,b,vi);
					detj = bamg::det(a,b,vj);
					//  if(SHOW) {  penthickness(3);
					// 	Move(vi);Line(vj);CurrentTh->inquire();penthickness(1);
					//         cout << Bh.Number(tbegin) << " " << Bh.Number(t) << " i= " << i <<" j= " <<  j << " k=" << k 
					//       	   << " deti= " << deti << " detj= " << detj 
					// 	     << " v = " << Bh.Number((*t)[i]) << (*t)[i].r <<  " " << Bh.Number((*t)[j]) << (*t)[j].r  << endl;}
					if (deti>0) // go to  i direction on gamma
						ocut = PreviousEdge[ocut];      
					else if (detj<=0) // go to j direction on gamma
						ocut = NextEdge[ocut];         
					TriangleAdjacent tadj =t->Adj(ocut);
					t = tadj;
					iedge= tadj; 
					if (t == tbegin) { // 
						double ba,bb;
						long int verbosity=2;
						if (verbosity>7) 
							cout << "       SplitEdge: All the edge " << A << B << nbegin <<  det(vi,vj,b) 
								<< " deti= " << deti <<  " detj=" <<detj << endl;
						TriangleAdjacent edge=CloseBoundaryEdge(a,t,ba,bb);
						Vertex & v0 = *edge.EdgeVertex(0), & v1 = *edge.EdgeVertex(1);
						NewItem(A,Metric(ba,v0,bb,v1));
						return;
					}
				} //  end while (t->det <0)
				// theoriticaly we have: deti =<0 and detj>0

				// computation of barycentric coor
				// test if the point b is on size on t
				// we revert vi,vj because vi,vj is def in Adj triangle
				if ( det(vi,vj,b)>=0) {
					if (verbosity>7)
						cout << "       SplitEdge: all AB outside " << A << B << endl;
					t=tbegin;
					Real8 ba,bb;
					TriangleAdjacent edge=CloseBoundaryEdge(b,t,ba,bb);
					NewItem(B,Metric(ba,*edge.EdgeVertex(0),bb,*edge.EdgeVertex(1)));
					return;
				}
				else
				{
					k = OppositeVertex[iedge];
					i=VerticesOfTriangularEdge[iedge][0];
					j=VerticesOfTriangularEdge[iedge][1];
					Real8 dij = detj-deti;
					assert(i+j+k == 0 + 1 +2);
					ba[j] =  detj/dij;
					ba[i] = -deti/dij;
					ba[k] = 0;
					// 	if(SHOW) cout << i << " " << j << " " << k << " " << ba[i] << " " << ba[j] << endl;
					ilast=NewItem(t,ba[0],ba[1],ba[2]); }
			}  //  outside departure



			// recherche the intersection of [a,b] with Bh Mesh.
			// we know  a triangle ta contening the vertex a
			// we have 2 case for intersection [a,b] with a edge [A,B] of Bh
			// 1) the intersection point is in ]A,B[
			// 2)                        is A or B
			// first version --- 
			for (;;) {
				//    t->Draw();
				if (iedge < 0) {
					i0 =0;i1=1;i2=2;
					dt[0] =bamg::det(a,b,(*t)[0]);
					dt[1] =bamg::det(a,b,(*t)[1]);
					dt[2] =bamg::det(a,b,(*t)[2]);}
				else {
					i2 = iedge;
					i0 = NextEdge[i2];
					i1 = NextEdge[i0]; 
					dt[VerticesOfTriangularEdge[iedge][0]] = detj;// we revert i,j because
					dt[VerticesOfTriangularEdge[iedge][1]] = deti;// we take the Triangle by the other side
					dt[iedge] = det(a,b,(*t)[OppositeVertex[iedge]]);}

					// so we have just to see the transition from - to + of the det0..2 on edge of t
					// because we are going from a to b
					if       ((dt[i=VerticesOfTriangularEdge[i0][0]] <  0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] > 0))
						ocut =i0;
					else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] <  0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] >  0))
						ocut =i1;
					else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] <  0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] >  0))
						ocut =i2;
					else if   ((dt[i=VerticesOfTriangularEdge[i0][0]] == 0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] >  0))
						ocut =i0;
					else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] == 0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] >  0))
						ocut =i1;
					else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] == 0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] >  0))
						ocut =i2;
					else if   ((dt[i=VerticesOfTriangularEdge[i0][0]] <  0) &&
							( dt[j=VerticesOfTriangularEdge[i0][1]] == 0))
						ocut =i0;
					else  if ((dt[i=VerticesOfTriangularEdge[i1][0]] <  0) &&
							(dt[j=VerticesOfTriangularEdge[i1][1]] == 0))
						ocut =i1;
					else  if ((dt[i=VerticesOfTriangularEdge[i2][0]] <  0) && 
							(dt[j=VerticesOfTriangularEdge[i2][1]] == 0))
						ocut =i2;
					else { //  On a edge (2 zero)
						k =0;
						if (dt[0]) ocut=0,k++; 
						if (dt[1]) ocut=1,k++; 
						if (dt[2]) ocut=2,k++;
						if(k == 1) {
							if (dt[ocut] >0) // triangle upper AB
								ocut = NextEdge[ocut];
							i= VerticesOfTriangularEdge[ocut][0];
							j= VerticesOfTriangularEdge[ocut][1];
						}
						else  {
							cerr << " Bug Split Edge " << endl;
							cerr << " dt[0]= " << dt[0] 
								<< " dt[1]= " << dt[1] 
								<< " dt[2]= "<< dt[2] << endl;
							cerr << i0 << " " << i1 << " " << i2 << endl;
							cerr << " A = " << A << " B= " << B << endl;
							cerr << " Triangle t = " <<  *t << endl;
							cerr << (*t)[0] << (*t)[1] << (*t)[0] << endl;
							cerr << " nbt = " << nbt << endl;
							MeshError(100);}}

							k = OppositeVertex[ocut];

							Icoor2 detbij = bamg::det((*t)[i],(*t)[j],b);


							if (detbij >= 0) { //we find the triangle contening b
								dt[0]=bamg::det((*t)[1],(*t)[2],b);
								dt[1]=bamg::det((*t)[2],(*t)[0],b);
								dt[2]=bamg::det((*t)[0],(*t)[1],b);
								Real8 dd = t->det;
								NewItem(t,dt[0]/dd,dt[1]/dd,dt[2]/dd);      
								return ;}
							else { // next triangle by  adjacent by edge ocut 
								deti = dt[i];
								detj = dt[j];
								Real4 dij = detj-deti;
								ba[i] =  detj/dij;
								ba[j] = -deti/dij;
								ba[3-i-j ] = 0;
								ilast=NewItem(t, ba[0],ba[1],ba[2]);      

								TriangleAdjacent ta =t->Adj(ocut);
								t = ta;
								iedge= ta; 
								if (t->det <= 0)  {
									double ba,bb;
									TriangleAdjacent edge=CloseBoundaryEdge(b,t,ba,bb);
									NewItem(B,Metric(ba,*edge.EdgeVertex(0),bb,*edge.EdgeVertex(1)));
									// 	cout << " return " << ba << " " << bb << endl;
									// ajoute le 03 frev 1997 par F. hecht
									return;
								}
							}// we  go outside of omega 
			} // for(;;)


		} // routine SplitEdge


		int  ListofIntersectionTriangles::NewItem(Triangle * tt,Real8 d0,Real8 d1,Real8 d2) { 
			register int n;
			R2 x(0,0);
			if ( d0) x =      (*tt)[0].r * d0;
			if ( d1) x = x +  (*tt)[1].r * d1;
			if ( d2) x = x +  (*tt)[2].r * d2;
			// newer add same point 
			if(!Size ||  Norme2_2(lIntTria[Size-1].x-x)) {
				if (Size==MaxSize) ReShape();
				lIntTria[Size].t=tt;
				lIntTria[Size].bary[0]=d0;
				lIntTria[Size].bary[1]=d1;
				lIntTria[Size].bary[2]=d2;
				lIntTria[Size].x = x;
				Metric m0,m1,m2;
				register Vertex * v;
				if ((v=(*tt)(0))) m0    = v->m;
				if ((v=(*tt)(1))) m1    = v->m;
				if ((v=(*tt)(2))) m2    = v->m;
				lIntTria[Size].m =  Metric(lIntTria[Size].bary,m0,m1,m2);
					n=Size++;}
			else n=Size-1;
			return n;
		}
		int ListofIntersectionTriangles::NewItem(R2 A,const Metric & mm) {  
			register int n;
			if(!Size ||  Norme2_2(lIntTria[Size-1].x-A)) {
				if (Size==MaxSize) ReShape();
				lIntTria[Size].t=0;
				lIntTria[Size].x=A;
				lIntTria[Size].m=mm;
				n=Size++;
			}
			else  n=Size-1;
			return  n; 
		}

		Real8  ListofIntersectionTriangles::Length()
		{
			//  cout << " n= " << Size << ":" ;
			assert(Size>0);
			// computation of the length      
			R2 C;
			Metric Mx,My;
			int ii,jj;
			R2 x,y,xy;

			SegInterpolation *SegI=lSegsI;
			SegI=lSegsI;
			lSegsI[NbSeg].last=Size;// improvement 

			int EndSeg=Size;

			y = lIntTria[0].x;
			Real8 sxy, s = 0;
			lIntTria[0].s =0;
			SegI->lBegin=s;

			for (jj=0,ii=1;ii<Size;jj=ii++) 
			{  
				// seg jj,ii
				x=y;
				y = lIntTria[ii].x;
				xy = y-x;
				Mx = lIntTria[ii].m;
				My = lIntTria[jj].m;
				//      Real8 &sx=  lIntTria[ii].sp; // previous seg
				//  Real8 &sy=  lIntTria[jj].sn; // next seg
				//      sx = Mx(xy);
				//      sy = My(xy);
				//   sxy = (Mx(xy)+ My(xy))/2.0;
				sxy =  LengthInterpole(Mx,My,xy);
				s += sxy;
				lIntTria[ii].s = s;
				if (ii == EndSeg) 
					SegI->lEnd=s,
						SegI++,
						EndSeg=SegI->last,
						SegI->lBegin=s;

				//    cout << ii << " " << jj << x<< y <<xy << s <<  lIntTria[ii].m  ;
			}
			len = s;
			SegI->lEnd=s;

			//  cout << " len= " << s << endl;
			return s;
		}

		Int4 ListofIntersectionTriangles::NewPoints(Vertex * vertices,Int4 & nbv,Int4  nbvx)
		{
			long int verbosity=0;


			const Int4 nbvold = nbv;
			Real8 s = Length();
			if (s <  1.5 ) return 0;
			//////////////////////   
			int ii = 1 ;
			R2 y,x;
			Metric My,Mx ;
			Real8 sx =0,sy;
			int nbi = Max(2,(int) (s+0.5));
			Real8 sint = s/nbi;
			Real8 si = sint;

			int EndSeg=Size;
			SegInterpolation *SegI=0;
			if (NbSeg) 
				SegI=lSegsI,EndSeg=SegI->last;

			for (int k=1;k<nbi;k++)
			{
				while ((ii < Size) && ( lIntTria[ii].s <= si )) 
					if (ii++ == EndSeg) 
						SegI++,EndSeg=SegI->last;

				int ii1=ii-1;
				x  =lIntTria[ii1].x;
				sx =lIntTria[ii1].s;
				Metric Mx=lIntTria[ii1].m;
				y  =lIntTria[ii].x;
				sy =lIntTria[ii].s;
				Metric My=lIntTria[ii].m;
				Real8 lxy = sy-sx;
				Real8 cy = abscisseInterpole(Mx,My,y-x,(si-sx)/lxy);

				R2 C;
				Real8 cx = 1-cy;
				C = SegI ? SegI->F(si): x * cx + y *cy;

				si += sint;
				if ( nbv<nbvx) {
					vertices[nbv].r = C;
					vertices[nbv++].m = Metric(cx,lIntTria[ii-1].m,cy,lIntTria[ii].m);
					if((verbosity/100%10)==2)
						cout << "   -- Add point " << nbv-1 << " " << vertices[nbv-1] << " " << vertices[nbv-1].m << endl;

				}
				else return nbv-nbvold;
			}
			return nbv-nbvold;
		}

		int SwapForForcingEdge(Vertex   *  & pva ,Vertex  * &   pvb ,
				TriangleAdjacent & tt1,Icoor2 & dets1, Icoor2 & detsa,Icoor2 & detsb, int & NbSwap)
		{ // l'arete ta coupe l'arete pva pvb
			// de cas apres le swap sa coupe toujours
			// on cherche l'arete suivante 
			// on suppose que detsa >0 et detsb <0
			// attention la routine echange pva et pvb 

			if(tt1.Locked()) return 0; // frontiere croise 

			TriangleAdjacent tt2 = Adj(tt1);
			Triangle *t1=tt1,*t2=tt2;// les 2 triangles adjacent
			Int1 a1=tt1,a2=tt2;// les 2 numero de l arete dans les 2 triangles
			assert ( a1 >= 0 && a1 < 3 );

			Vertex & sa= (* t1)[VerticesOfTriangularEdge[a1][0]];
			Vertex & s1= (*t1)[OppositeVertex[a1]];
			Vertex & s2= (*t2)[OppositeVertex[a2]];


			Icoor2 dets2 = det(*pva,*pvb,s2);
			Icoor2 det1=t1->det , det2=t2->det ;
			Icoor2 detT = det1+det2;
			assert((det1>0 ) && (det2 > 0));
			assert ( (detsa < 0) && (detsb >0) ); // [a,b] cut infinite line va,bb
			Icoor2 ndet1 = bamg::det(s1,sa,s2);
			Icoor2 ndet2 = detT - ndet1;

			int ToSwap =0; //pas de swap
			if ((ndet1 >0) && (ndet2 >0)) 
			{ // on peut swaper  
				if ((dets1 <=0 && dets2 <=0) || (dets2 >=0 && detsb >=0))
					ToSwap =1; 
				else // swap alleatoire 
					if (BinaryRand()) 
						ToSwap =2; 
			}
			if (ToSwap) NbSwap++,
				bamg::swap(t1,a1,t2,a2,&s1,&s2,ndet1,ndet2);

			int ret=1;

			if (dets2 < 0) {// haut
				dets1 = ToSwap ? dets1 : detsa ;
				detsa = dets2; 
				tt1 =  Previous(tt2) ;}
			else if (dets2 > 0){// bas 
				dets1 = ToSwap ? dets1 : detsb ;
				detsb = dets2;
				//xxxx tt1 = ToSwap ? tt1 : Next(tt2);
				if(!ToSwap) tt1 =  Next(tt2);
			}
			else { // changement de sens 
				if (ForDebugging)  cout << "changement de sens" << endl;
				ret = -1;
				Exchange(pva,pvb);
				Exchange(detsa,detsb);
				Exchange(dets1,dets2);
				Exchange(tt1,tt2);
				dets1=-dets1;
				dets2=-dets2;
				detsa=-detsa;
				detsb=-detsb;

				if (ToSwap) 
					if (dets2 < 0) {// haut
						dets1 = (ToSwap ? dets1 : detsa) ;
						detsa = dets2; 
						tt1 =  Previous(tt2) ;}
					else if (dets2 > 0){// bas 
						dets1 = (ToSwap ? dets1 : detsb) ;
						detsb =  dets2;
						if(!ToSwap) tt1 =  Next(tt2);
					}
					else {// on a fin ???
						tt1 = Next(tt2);
						ret =0;}

			}
			return ret;
		}

		int ForceEdge(Vertex &a, Vertex & b,TriangleAdjacent & taret)  
		{ 
			int NbSwap =0;
			assert(a.t && b.t); // the 2 vertex is in a mesh 
			int k=0;
			taret=TriangleAdjacent(0,0); // erreur 

			TriangleAdjacent tta(a.t,EdgesVertexTriangle[a.vint][0]);
			Vertex   *v1, *v2 = tta.EdgeVertex(0),*vbegin =v2;
			// we turn around a in the  direct sens  

			Icoor2 det2 = v2 ? det(*v2,a,b): -1 , det1;
			if(v2) // normal case 
				det2 = det(*v2,a,b);
			else { // no chance infini vertex try the next
				tta= Previous(Adj(tta));
				v2 = tta.EdgeVertex(0);
				vbegin =v2;
				assert(v2);
				det2 = det(*v2,a,b);
				//   cout << " No Change try the next" << endl;
			}

			while (v2 != &b) {
				TriangleAdjacent tc = Previous(Adj(tta));    
				v1 = v2; 
				v2 = tc.EdgeVertex(0);
				det1 = det2;
				det2 =  v2 ? det(*v2,a,b): det2; 

				if((det1 < 0) && (det2 >0)) { 
					// try to force the edge 
					Vertex * va = &a, *vb = &b;
					tc = Previous(tc);
					assert ( v1 && v2);
					Icoor2 detss = 0,l=0,ks;
					// cout << "Real ForcingEdge " << *va << *vb << detss << endl;
					while ((ks=SwapForForcingEdge(  va,  vb, tc, detss, det1,det2,NbSwap)))
						if(l++ > 10000000) {
							cerr << " Loop in forcing Egde AB" 
								<<"\n vertex A " << a 
								<<"\n vertex B " <<  b 
								<<"\n nb de swap " << NbSwap 
								<<"\n nb of try  swap too big = " <<  l << " gearter than " <<  1000000 << endl;

							if ( CurrentTh ) 
								cerr << " vertex number " << CurrentTh->Number(a) << " " <<  CurrentTh->Number(b) << endl;
							MeshError(990);
						}
					Vertex *aa = tc.EdgeVertex(0), *bb = tc.EdgeVertex(1);
					if (( aa == &a ) && (bb == &b) ||  (bb ==  &a ) && (aa == &b)) {
						tc.SetLock();
						a.Optim(1,0);
						b.Optim(1,0);
						taret = tc;
						return NbSwap;
					}
					else 
					{
						taret = tc;
						return -2; // error  boundary is crossing
						/*	  cerr << "Fatal Error  boundary is crossing  ";
							  if(CurrentTh)
							  {
							  cerr << " edge:  [" << CurrentTh->Number(a) << ", " << CurrentTh->Number(b) <<  " ] and [ ";
							  cerr    << CurrentTh->Number(aa) << " " << CurrentTh->Number(bb) << " ] " << endl;
							  }
							  MeshError(991);
							  */	  
					}
				}
				tta = tc;
				assert(k++<2000);
				if ( vbegin == v2 ) return -1;// error 
			}

			tta.SetLock();
			taret=tta;
			a.Optim(1,0);
			b.Optim(1,0);
			return NbSwap; 
		}




		Real8  Vertex::Smoothing(Triangles & Th,const Triangles & BTh,Triangle  * & tstart ,Real8 omega)
		{
			register Vertex * s  = this;
			Vertex &vP = *s,vPsave=vP;
			//  if (vP.on) return 0;// Don't move boundary vertex  

			register Triangle * tbegin= t , *tria = t , *ttc;

			register int k=0,kk=0,j = EdgesVertexTriangle[vint][0],jc;
			R2 P(s->r),PNew(0,0);
			//  cout << BTh.quadtree << " " <<  BTh.quadtree->root << endl;
			// assert(BTh.quadtree && BTh.quadtree->root);
			do {
				k++; 

				if (!tria->Hidden(j))
				{
					Vertex &vQ = (*tria)[VerticesOfTriangularEdge[j][0]]; 

					R2 Q = vQ,QP(P-Q);
					Real8 lQP = LengthInterpole(vP,vQ,QP);
					PNew += Q+QP/Max(lQP,1e-20);
					kk ++;
				}
				ttc =  tria->TriangleAdj(j);
				jc = NextEdge[tria->NuEdgeTriangleAdj(j)];
				tria = ttc;
				j = NextEdge[jc];
				assert(k<2000);
			} while ( tbegin != tria); 
			if (kk<4) return 0;
			PNew = PNew/(Real8)kk;
			R2 Xmove((PNew-P)*omega);
			PNew = P+Xmove;
			Real8 delta=Norme2_2(Xmove); 


			// 
			Icoor2 deta[3];
			I2 IBTh  = BTh.toI2(PNew);

			tstart=BTh.FindTriangleContening(IBTh,deta,tstart);  

			if (tstart->det <0) 
			{ // outside
				double ba,bb;
				TriangleAdjacent edge= CloseBoundaryEdge(IBTh,tstart,ba,bb) ;
				tstart = edge;
				vP.m= Metric(ba,*edge.EdgeVertex(0),bb,*edge.EdgeVertex(1));
			}
			else 
			{ // inside
				Real8   aa[3];
				Real8 s = deta[0]+deta[1]+deta[2];
				aa[0]=deta[0]/s;
				aa[1]=deta[1]/s;
				aa[2]=deta[2]/s;
				vP.m = Metric(aa,(*tstart)[0],(*tstart)[1],(*tstart)[2]);
			}

			// recompute the det of the triangle
			vP.r = PNew;

			vP.i = Th.toI2(PNew);

			Vertex vPnew = vP;

			int ok=1;
			int loop=1;
			k=0;
			while (ok) 
			{
				ok =0;
				do {
					k++; 
					double detold = tria->det;
					tria->det =  bamg::det( (*tria)[0],(*tria)[1]  ,(*tria)[2]);
					if (loop) 
					{
						Vertex *v0,*v1,*v2,*v3;
						if (tria->det<0) ok =1;			       
						else if (tria->Quadrangle(v0,v1,v2,v3))
						{
							vP = vPsave;
							Real8 qold =QuadQuality(*v0,*v1,*v2,*v3);
							vP = vPnew;
							Real8 qnew = QuadQuality(*v0,*v1,*v2,*v3);
							if (qnew<qold) ok = 1;
						}
						else if ( (double)tria->det < detold/2 ) ok=1;

					}
					tria->SetUnMarkUnSwap(0);
					tria->SetUnMarkUnSwap(1);
					tria->SetUnMarkUnSwap(2);
					ttc =  tria->TriangleAdj(j);
					jc = NextEdge[tria->NuEdgeTriangleAdj(j)];
					tria = ttc;
					j = NextEdge[jc];
					assert(k<2000);
				} while ( tbegin != tria); 
				if (ok && loop) vP=vPsave; // no move 
				loop=0;
			}
			return delta;
		}

		Vertex * Triangles::NearestVertex(Icoor1 i,Icoor1 j) 
		{ return  quadtree->NearestVertex(i,j); } 


		void Triangles::PreInit(Int4 inbvx,char *fname)
		{
			long int verbosity=0;

			srand(19999999);
			OnDisk =0;
			NbRef=0;
			//  allocGeometry=0;
			identity=0;
			NbOfTriangleSearchFind =0;
			NbOfSwapTriangle =0;
			nbiv=0;
			nbv=0;
			nbvx=inbvx;
			nbt=0;
			NbOfQuad = 0;
			nbtx=2*inbvx-2;
			NbSubDomains=0;
			NbVertexOnBThVertex=0;
			NbVertexOnBThEdge=0;
			VertexOnBThVertex=0;
			VertexOnBThEdge=0;

			NbCrackedVertices=0;
			NbCrackedEdges =0;
			CrackedEdges  =0;  
			nbe = 0; 
			name = fname ;

			if (inbvx) {
				vertices=new Vertex[nbvx];
				assert(vertices);
				ordre=new (Vertex* [nbvx]);
				assert(ordre);
				triangles=new Triangle[nbtx];
				assert(triangles);}
			else {
				vertices=0;
				ordre=0;
				triangles=0;
				nbtx=0;
			}
			if ( name || inbvx)
			{
				time_t timer =time(0);
				char buf[70];     
				strftime(buf ,70,", Date: %y/%m/%d %H:%M %Ss",localtime(&timer));
				counter++; 
				char countbuf[30];   
				sprintf(countbuf,"%d",counter);
				int lg =0 ;
				if (&BTh != this && BTh.name)
					lg = strlen(BTh.name)+4;
				identity = new char[ lg + strlen(buf) + strlen(countbuf)+ 2  + 10 + ( Gh.name ? strlen(Gh.name) + 4 : 0)];
				identity[0]=0;
				if (lg)
					strcat(strcat(strcat(identity,"B="),BTh.name),", ");

				if (Gh.name)
					strcat(strcat(identity,"G="),Gh.name);
				strcat(strcat(identity,";"),countbuf);
				strcat(identity,buf);
				// cout << "New MAILLAGE "<< identity << endl;
			} 

			quadtree=0;
			//  edgescomponante=0;
			edges=0;
			VerticesOnGeomVertex=0;
			VerticesOnGeomEdge=0;
			NbVerticesOnGeomVertex=0;
			NbVerticesOnGeomEdge=0;
			//  nbMaxIntersectionTriangles=0;
			//  lIntTria;
			subdomains=0;
			NbSubDomains=0;
			//  Meshbegin = vertices;
			//  Meshend  = vertices + nbvx;
			if (verbosity>98) 
				cout << "Triangles::PreInit() " << nbvx << " " << nbtx 
					<< " " << vertices 
					<< " " << ordre << " " <<  triangles <<endl;
		}


double QuadQuality(const Vertex & a,const Vertex &b,const Vertex &c,const Vertex &d) {
	// calcul de 4 angles --
	R2 A((R2)a),B((R2)b),C((R2)c),D((R2)d);
	R2 AB(B-A),BC(C-B),CD(D-C),DA(A-D);
	//  Move(A),Line(B),Line(C),Line(D),Line(A);
	const Metric & Ma  = a;
	const Metric & Mb  = b;
	const Metric & Mc  = c;
	const Metric & Md  = d;

	double lAB=Norme2(AB);
	double lBC=Norme2(BC);
	double lCD=Norme2(CD);
	double lDA=Norme2(DA);
	AB /= lAB;  BC /= lBC;  CD /= lCD;  DA /= lDA;
	// version aniso 
	double cosDAB= Ma(DA,AB)/(Ma(DA)*Ma(AB)),sinDAB= Det(DA,AB);
	double cosABC= Mb(AB,BC)/(Mb(AB)*Mb(BC)),sinABC= Det(AB,BC);
	double cosBCD= Mc(BC,CD)/(Mc(BC)*Mc(CD)),sinBCD= Det(BC,CD);
	double cosCDA= Md(CD,DA)/(Md(CD)*Md(DA)),sinCDA= Det(CD,DA);
	double sinmin=Min(Min(sinDAB,sinABC),Min(sinBCD,sinCDA));
	if (sinmin<=0) return sinmin;
	return 1.0-Max(Max(Abs(cosDAB),Abs(cosABC)),Max(Abs(cosBCD),Abs(cosCDA)));
}

}

