#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"

#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>
#include "Mesh2.h"
#include "QuadTree.h"
#include "SetOfE4.h"

namespace bamg {

	static const  Direction NoDirOfSearch=Direction();

	/*Constructors/Destructors*/
	/*FUNCTION Triangles::Triangles(BamgMesh* bamgmesh, BamgOpts* bamgopts){{{1*/
	Triangles::Triangles(BamgMesh* bamgmesh, BamgOpts* bamgopts):Gh(*(new Geometry())),BTh(*this){ 

		PreInit(0,"none");
		OnDisk = 1;

		ReadMesh(bamgmesh,bamgopts);
		SetIntCoor();
		FillHoleInMesh();
	}
	/*}}}1*/

	/*IO*/
	/*FUNCTION Triangles::WriteMesh {{{1*/
	void Triangles::WriteMesh(BamgMesh* bamgmesh,BamgOpts* bamgopts){

		int i,j;
		int verbose;

		verbose=bamgopts->verbose;
		Int4 *reft = new Int4[nbt];
		Int4 nbInT = ConsRefTriangle(reft);

		//Vertices
		if(verbose>3) printf("      writing Vertices\n");
		bamgmesh->NumVertices=nbv;
		xfree((void**)&bamgmesh->Vertices);
		if (nbv){
			bamgmesh->Vertices=(double*)xmalloc(3*nbv*sizeof(double));
			for (i=0;i<nbv;i++){
				bamgmesh->Vertices[i*3+0]=vertices[i].r.x;
				bamgmesh->Vertices[i*3+1]=vertices[i].r.y;
				bamgmesh->Vertices[i*3+2]=vertices[i].ref();
			}
		}
		else{
			bamgmesh->Vertices=NULL;
		}

		//Edges
		if(verbose>3) printf("      writing Edges\n");
		bamgmesh->NumEdges=nbe;
		xfree((void**)&bamgmesh->Edges);
		if (nbe){
			bamgmesh->Edges=(double*)xmalloc(3*nbe*sizeof(double));
			for (i=0;i<nbe;i++){
				bamgmesh->Edges[i*3+0]=Number(edges[i][0])+1; //back to M indexing
				bamgmesh->Edges[i*3+1]=Number(edges[i][1])+1; //back to M indexing
				bamgmesh->Edges[i*3+2]=edges[i].ref;
			}
		}
		else{
			bamgmesh->Edges=NULL;
		}

		//CrackedEdges
		if(verbose>3) printf("      writing CrackedEdges\n");
		bamgmesh->NumCrackedEdges=NbCrackedEdges;
		xfree((void**)&bamgmesh->CrackedEdges);
		if (NbCrackedEdges){
			bamgmesh->CrackedEdges=(double*)xmalloc(2*NbCrackedEdges*sizeof(double));
			for (i=0;i<NbCrackedEdges;i++){
				bamgmesh->CrackedEdges[i*2+0]=Number(CrackedEdges[i].a.edge)+1; //back to M indexing
				bamgmesh->CrackedEdges[i*2+1]=Number(CrackedEdges[i].b.edge)+1; //back to M indexing
			}
		}
		else{
			bamgmesh->CrackedEdges=NULL;
		}

		//Triangles
		if(verbose>3) printf("      writing Triangles\n");
		Int4 k=nbInT-NbOfQuad*2;
		Int4 num=0;
		bamgmesh->NumTriangles=k;
		xfree((void**)&bamgmesh->Triangles);
		if (k){
			bamgmesh->Triangles=(double*)xmalloc(4*k*sizeof(double));
			for (i=0;i<nbt;i++){
				Triangle &t=triangles[i];
				if (reft[i]>=0 && !( t.Hidden(0) || t.Hidden(1) || t.Hidden(2) )){
					bamgmesh->Triangles[num*4+0]=Number(t[0])+1; //back to M indexing
					bamgmesh->Triangles[num*4+1]=Number(t[1])+1; //back to M indexing
					bamgmesh->Triangles[num*4+2]=Number(t[2])+1; //back to M indexing
					bamgmesh->Triangles[num*4+3]=subdomains[reft[i]].ref;
					num=num+1;
				}
			}
		}
		else{
			bamgmesh->Triangles=NULL;
		}

		//Quadrilaterals
		if(verbose>3) printf("      writing Quadrilaterals\n");
		bamgmesh->NumQuadrilaterals=NbOfQuad;
		xfree((void**)&bamgmesh->Quadrilaterals);
		if (NbOfQuad){
			bamgmesh->Quadrilaterals=(double*)xmalloc(5*NbOfQuad*sizeof(double));
			for (i=0;i<nbt;i++){
				Triangle &t =triangles[i];
				Triangle* ta;
				Vertex *v0,*v1,*v2,*v3;
				if (reft[i]<0) continue;
				if ((ta=t.Quadrangle(v0,v1,v2,v3)) !=0 && &t<ta) { 
					bamgmesh->Quadrilaterals[i*5+0]=Number(v0)+1; //back to M indexing
					bamgmesh->Quadrilaterals[i*5+1]=Number(v1)+1; //back to M indexing
					bamgmesh->Quadrilaterals[i*5+2]=Number(v2)+1; //back to M indexing
					bamgmesh->Quadrilaterals[i*5+3]=Number(v3)+1; //back to M indexing
					bamgmesh->Quadrilaterals[i*5+4]=subdomains[reft[i]].ref;
				}
			}
		}
		else{
			bamgmesh->Quadrilaterals=NULL;
		}

		//SubDomains
		if(verbose>3) printf("      writing SubDomains\n");
		bamgmesh->NumSubDomains=NbSubDomains;
		xfree((void**)&bamgmesh->SubDomains);
		if (NbSubDomains){
			bamgmesh->SubDomains=(double*)xmalloc(4*NbSubDomains*sizeof(double));
			for (i=0;i<NbSubDomains;i++){
				bamgmesh->SubDomains[i*4+0]=3;
				bamgmesh->SubDomains[i*4+1]=reft[Number(subdomains[i].head)];
				bamgmesh->SubDomains[i*4+2]=1;
				bamgmesh->SubDomains[i*4+3]=subdomains[i].ref;
			}
		}
		else{
			bamgmesh->SubDomains=NULL;
		}

		//SubDomainsFromGeom
		if(verbose>3) printf("      writing SubDomainsFromGeom\n");
		bamgmesh->NumSubDomainsFromGeom=Gh.NbSubDomains;
		xfree((void**)&bamgmesh->SubDomainsFromGeom);
		if (Gh.NbSubDomains){
			bamgmesh->SubDomainsFromGeom=(double*)xmalloc(4*Gh.NbSubDomains*sizeof(double));
			for (i=0;i<Gh.NbSubDomains;i++){
				bamgmesh->SubDomainsFromGeom[i*4+0]=2;
				bamgmesh->SubDomainsFromGeom[i*4+1]=Number(subdomains[i].edge)+1; //back to Matlab indexing
				bamgmesh->SubDomainsFromGeom[i*4+2]=subdomains[i].sens;
				bamgmesh->SubDomainsFromGeom[i*4+3]=Gh.subdomains[i].ref;
			}
		}
		else{
			bamgmesh->SubDomainsFromGeom=NULL;
		}

		//VerticesOnGeomVertex
		if(verbose>3) printf("      writing VerticesOnGeometricVertex\n");
		bamgmesh->NumVerticesOnGeometricVertex=NbVerticesOnGeomVertex;
		xfree((void**)&bamgmesh->VerticesOnGeometricVertex);
		if (NbVerticesOnGeomVertex){
			bamgmesh->VerticesOnGeometricVertex=(double*)xmalloc(2*NbVerticesOnGeomVertex*sizeof(double));
			for (i=0;i<NbVerticesOnGeomVertex;i++){
				VertexOnGeom &v=VerticesOnGeomVertex[i];
				if (!v.OnGeomVertex()){
					throw ErrorException(__FUNCT__,exprintf("A vertices supposed to be OnGeometricVertex is actually not"));
				}
				bamgmesh->VerticesOnGeometricVertex[i*2+0]=Number((Vertex*)v)+1; //back to Matlab indexing
				bamgmesh->VerticesOnGeometricVertex[i*2+1]=Gh.Number(( GeometricalVertex*)v)+1; //back to Matlab indexing
			}
		}
		else{
			bamgmesh->VerticesOnGeometricVertex=NULL;
		}

		//VertexOnGeometricEdge
		if(verbose>3) printf("      writing VerticesOnGeometricEdge\n");
		bamgmesh->NumVerticesOnGeometricEdge=NbVerticesOnGeomEdge;
		xfree((void**)&bamgmesh->VerticesOnGeometricEdge);
		if (NbVerticesOnGeomEdge){
			bamgmesh->VerticesOnGeometricEdge=(double*)xmalloc(3*NbVerticesOnGeomEdge*sizeof(double));
			for (i=0;i<NbVerticesOnGeomEdge;i++){
				const VertexOnGeom &v=VerticesOnGeomEdge[i];
				if (!v.OnGeomEdge()){
					throw ErrorException(__FUNCT__,exprintf("A vertices supposed to be OnGeometricEdge is actually not"));
				}
				bamgmesh->VerticesOnGeometricEdge[i*3+0]=Number((Vertex*)v)+1; //back to Matlab indexing
				bamgmesh->VerticesOnGeometricEdge[i*3+1]=Gh.Number((const GeometricalEdge*)v)+1; //back to Matlab indexing
				bamgmesh->VerticesOnGeometricEdge[i*3+2]=(double)v;
			}
		}
		else{
			bamgmesh->VerticesOnGeometricEdge=NULL;
		}

		//EdgesOnGeometricEdge
		if(verbose>3) printf("      writing EdgesOnGeometricEdge\n");
		k=0;
		for (i=0;i<nbe;i++){
			if (edges[i].on) k=k+1;
		}
		bamgmesh->NumEdgesOnGeometricEdge=k;
		xfree((void**)&bamgmesh->EdgesOnGeometricEdge);
		if (k){
			bamgmesh->EdgesOnGeometricEdge=(double*)xmalloc(2*(int)k*sizeof(double));
			int count=0;
			for (i=0;i<nbe;i++){
				if (edges[i].on){
					bamgmesh->EdgesOnGeometricEdge[count*2+0]=(double)i+1; //back to Matlab indexing
					bamgmesh->EdgesOnGeometricEdge[count*2+1]=(double)Gh.Number(edges[i].on)+1; //back to Matlab indexing
					count=count+1;
				}
			}
		}
		else{
			bamgmesh->EdgesOnGeometricEdge=NULL;
		}
	}
	/*}}}1*/
	/*FUNCTION Triangles::ReadMesh{{{1*/
	void Triangles::ReadMesh(BamgMesh* bamgmesh, BamgOpts* bamgopts){

		int verbose;
		Real8 Hmin = HUGE_VAL;// the infinie value 
		Int4 i1,i2,i3,iref;
		Int4 i,j;
		Int4 hvertices =0;
		Int4 ifgeom=0;
		Metric M1(1);
		int Version=1,dim=2;

		verbose=bamgopts->verbose;

		nbv=bamgmesh->NumVertices;
		nbvx=nbv;
		nbt=bamgmesh->NumTriangles;
		nbiv=nbvx;

		//Vertices
		if(bamgmesh->Vertices){
			if(verbose>3) printf("      processing Vertices\n");

			vertices=(Vertex*)xmalloc(nbv*sizeof(Vertex));
			ordre=(Vertex**)xmalloc(nbv*sizeof(Vertex*));

			for (i=0;i<nbv;i++){
				vertices[i].r.x=bamgmesh->Vertices[i*3+0];
				vertices[i].r.y=bamgmesh->Vertices[i*3+1];
				vertices[i].ReferenceNumber=1;
				vertices[i].DirOfSearch =NoDirOfSearch;
				vertices[i].m=M1;
				vertices[i].color=(Int4)bamgmesh->Vertices[i*3+2];
			}
			nbtx=2*nbvx-2; // for filling The Holes and quadrilaterals 
		}
		else{
			if(verbose>3) throw ErrorException(__FUNCT__,exprintf("no Vertices found in the initial mesh"));
		}

		//Triangles
		if(bamgmesh->Triangles){
			if(verbose>3) printf("      processing Triangles\n");
			triangles =new Triangle[nbtx]; //we cannot allocate only nbt triangles since 
			//other triangles will be added for each edge
			for (i=0;i<nbt;i++){
				Triangle & t = triangles[i];
				i1=(Int4)bamgmesh->Triangles[i*4+0]-1; //for C indexing
				i2=(Int4)bamgmesh->Triangles[i*4+1]-1; //for C indexing
				i3=(Int4)bamgmesh->Triangles[i*4+2]-1; //for C indexing
				t=Triangle(this,i1,i2,i3);
				t.color=(Int4)bamgmesh->Triangles[i*4+3];
			}
		}
		else{
			if(verbose>3) throw ErrorException(__FUNCT__,exprintf("no Triangles found in the initial mesh"));
		}

		//Quadrilaterals
		if(bamgmesh->Quadrilaterals){
			if(verbose>3) printf("      processing Quadrilaterals\n");
			Int4 i1,i2,i3,i4,iref;
			triangles =new Triangle[nbt];
			for (i=0;i<bamgmesh->NumQuadrilaterals;i++){
				Triangle & t1 = triangles[2*i];
				Triangle & t2 = triangles[2*i+1];
				i1=(Int4)bamgmesh->Quadrilaterals[i*4+0]-1; //for C indexing
				i2=(Int4)bamgmesh->Quadrilaterals[i*4+1]-1; //for C indexing
				i3=(Int4)bamgmesh->Quadrilaterals[i*4+2]-1; //for C indexing
				i4=(Int4)bamgmesh->Quadrilaterals[i*4+3]-1; //for C indexing
				t1=Triangle(this,i1,i2,i3);
				t2=Triangle(this,i3,i4,i1);
				t1.color=1; //reference = 1 for all triangles since it has not been specified
				t2.color=1; //reference = 1 for all triangles since it has not been specified
				t1.SetHidden(OppositeEdge[1]); // two times  because the adj was not created 
				t2.SetHidden(OppositeEdge[1]); 
			}
		}
		else{
			if(verbose>3) printf("      no Quadrilaterals found\n");
		}

		//hVertices
		if(bamgmesh->hVertices){
			if(verbose>3) printf("      processing hVertices\n");
			hvertices=1;
			for (i=0;i< nbv;i++){
				vertices[i].m=Metric((Real4)bamgmesh->hVertices[i]);
			}
		}
		else{
			if(verbose>3) printf("      no hVertices found\n");
		}

		//VerVerticesOnGeometricEdge
		if(bamgmesh->VerticesOnGeometricEdge){
			if(verbose>3) printf("      processing VerticesOnGeometricEdge\n");
			NbVerticesOnGeomEdge=bamgmesh->NumVerticesOnGeometricEdge;
			VerticesOnGeomEdge= new  VertexOnGeom[NbVerticesOnGeomEdge] ;
			for (i=0;i<NbVerticesOnGeomEdge;i++){
				Int4  i1,i2;
				Real8 s;
				i1=(Int4)bamgmesh->VerticesOnGeometricEdge[i*3+0]-1; //for C indexing
				i2=(Int4)bamgmesh->VerticesOnGeometricEdge[i*3+1]-1; //for C indexing
				s =(Int4)bamgmesh->VerticesOnGeometricEdge[i*3+2];
				VerticesOnGeomEdge[i]=VertexOnGeom(vertices[i1],Gh.edges[i2],s);
			}
		}
		else{
			if(verbose>3) printf("      no VertexOnGeometricEdge found\n");
		}

		//Edges
		if (bamgmesh->Edges){
			int i1,i2;
			R2 zero2(0,0);
			Real4 *len =0;

			if(verbose>3) printf("      processing Edges\n");
			nbe=bamgmesh->NumEdges;
			edges = new Edge[nbe];

			if (!hvertices) {
				len = new Real4[nbv];
				for(i=0;i<nbv;i++)
				 len[i]=0;
			}

			for (i=0;i<nbe;i++){
				i1=(int)bamgmesh->Edges[i*3+0]-1; //-1 for C indexing
				i2=(int)bamgmesh->Edges[i*3+1]-1; //-1 for C indexing
				edges[i].v[0]= vertices +i1;
				edges[i].v[1]= vertices +i2;
				edges[i].adj[0]=0;
				edges[i].adj[1]=0;
				R2 x12 = vertices[i2].r-vertices[i1].r;
				Real8 l12=sqrt( (x12,x12));        

				if (!hvertices) {
					vertices[i1].color++;
					vertices[i2].color++;
					len[i1]+= l12;
					len[i2] += l12;
				}
				Hmin = Min(Hmin,l12);
			}

			// definition  the default of the given mesh size 
			if (!hvertices){
				for (i=0;i<nbv;i++) 
				 if (vertices[i].color > 0) 
				  vertices[i].m=  Metric(len[i] /(Real4) vertices[i].color);
				 else 
				  vertices[i].m=  Metric(Hmin);
				delete [] len;
			}

			// construction of edges[].adj 
			for (i=0;i<nbv;i++){ 
				vertices[i].color = (vertices[i].color ==2) ? -1 : -2;
			}
			for (i=0;i<nbe;i++){
				for (j=0;j<2;j++) { 
					Vertex *v=edges[i].v[j];
					Int4 i0=v->color,j0;
					if(i0==-1){
						v->color=i*2+j;
					}
					else if (i0>=0) {// i and i0 edge are adjacent by the vertex v
						j0 =  i0%2;
						i0 =  i0/2;
						assert( v ==  edges[i0 ].v[j0]);
						edges[i ].adj[ j ] =edges +i0;
						edges[i0].adj[ j0] =edges +i ;
						assert(edges[i0].v[j0] == v);
						v->color = -3;
					}
				}
			}
		}
		else{
			if(verbose>3) printf("      no Edges found\n");
		}

		//EdgeOnGeometricEdge
		if(bamgmesh->EdgesOnGeometricEdge){
			if(verbose>3) printf("      processing EdgesOnGeometricEdge\n");
			int i1,i2,i,j;
			i2=bamgmesh->NumEdgesOnGeometricEdge;
			for (i1=0;i1<i2;i1++) {
				i=(int)bamgmesh->EdgesOnGeometricEdge[i*2+0];
				j=(int)bamgmesh->EdgesOnGeometricEdge[i*2+1];
				if(!(i>0 && j >0 && i <= nbe && j <= Gh.nbe)) {
					throw ErrorException(__FUNCT__,exprintf("EdgesOnGeometricEdge error: We must have : (i>0 && j >0 && i <= nbe && j <= Gh.nbe)"));
				}
				edges[i-1].on = Gh.edges + j-1;
			}
		}
		else{
			if(verbose>3) printf("      no EdgesOnGeometricEdge found\n");
		}

		//SubDomain
		if(bamgmesh->SubDomains){
			Int4 i3,head,sens;
			if(verbose>3) printf("      processing SubDomains\n");
			NbSubDomains=bamgmesh->NumSubDomains;
			subdomains = new SubDomain [ NbSubDomains ];
			for (i=0;i<NbSubDomains;i++) {
				i3  =(int)bamgmesh->SubDomains[i*3+0];
				head=(int)bamgmesh->SubDomains[i*3+1]-1;//C indexing
				sens=(int)bamgmesh->SubDomains[i*3+2];
				if (i3!=23) throw ErrorException(__FUNCT__,exprintf("Bad Subdomain definition: first number should be 3"));
				if (head<0 || head>=nbt) throw ErrorException(__FUNCT__,exprintf("Bad Subdomain definition: head should in [1 %i] (triangle number)",nbt));
				subdomains[i].head = triangles+head;
			}
		}
		else{
			if(verbose>3) printf("      no SubDomains found\n");
		}

		/*Recreate geometry if needed*/
		if(1!=0) {
			printf("Warning: mesh present but no geometry found. Reconstructing...\n");
			/*Recreate geometry: */
			ConsGeometry(bamgopts->MaximalAngleOfCorner*Pi/180);
			Gh.AfterRead();
		}
	}
	/*}}}1*/

	/*Others*/
	/*FUNCTION Triangles::ConsGeometry{{{1*/
	void Triangles::ConsGeometry(Real8 cutoffradian,int *equiedges) // construct a geometry if no geo 
	  {
		//  if equiedges existe taille nbe 
		//   equiedges[i]/2 == i  original
		//   equiedges[i]/2 = j  =>   equivalence entre i et j => meme maillage
		//   equiedges[i]%2   : 0 meme sens , 1 pas meme sens 
		//       
		// --------------------------
		long int verbosity=0;
		if (verbosity>1) 
		 cout << "  -- construction of the geometry from the 2d mesh " << endl;
		if (nbt<=0 || nbv <=0 ) { MeshError(101);}

		// construction of the edges 
		//  Triangles * OldCurrentTh =CurrentTh;
		CurrentTh=this;
		//  Int4 NbTold = nbt;
		// generation of the integer coor
		// generation of the adjacence of the triangles
		if (cutoffradian>=0)
		 Gh.MaximalAngleOfCorner = cutoffradian;
		SetOfEdges4 * edge4= new SetOfEdges4(nbt*3,nbv);
		Int4 * st = new Int4[nbt*3];
		Int4 i,k;
		int j; 
		if (Gh.name) delete Gh.name;
		Gh.name = new char [ name ? strlen(name) + 15 : 50 ];
		Gh.name[0]=0;
		strcat(Gh.name,"cons from: ");
		if (name) strcat(Gh.name,name);
		else strcat(Gh.name," a mesh with no name");
		for (i=0;i<nbt*3;i++)
		 st[i]=-1;
		Int4 kk =0;

		Int4 nbeold = nbe;
		for (i=0;i<nbe;i++)
		  {
			//      cout << i << " " << Number(edges[i][0]) << " " << Number(edges[i][1]) << endl;
			edge4->addtrie(Number(edges[i][0]),Number(edges[i][1]));
		  }
		if (nbe !=  edge4->nb())
		  { 
			cerr << " Some Double edge in the mesh, the number is " << nbe 
			  << " nbe4=" << edge4->nb()  << endl;
			MeshError(1002);
		  }
		for (i=0;i<nbt;i++)
		 for  (j=0;j<3;j++)
			{
			 // Int4 i0,i1;
			 Int4 k =edge4->addtrie(Number(triangles[i][VerticesOfTriangularEdge[j][0]]),
						 Number(triangles[i][VerticesOfTriangularEdge[j][1]]));
			 Int4 invisible = triangles[i].Hidden(j);
			 if(st[k]==-1)
			  st[k]=3*i+j;
			 else if(st[k]>=0) {
				 assert( ! triangles[i].TriangleAdj(j) && !triangles[st[k] / 3].TriangleAdj((int) (st[k]%3)));

				 triangles[i].SetAdj2(j,triangles + st[k] / 3,(int) (st[k]%3));
				 if (invisible)  triangles[i].SetHidden(j);
				 if (k<nbe) {
					 triangles[i].SetLocked(j);
				 }
				 st[k]=-2-st[k]; }
			 else {
				 cerr << " The edge (" 
					<< Number(triangles[i][VerticesOfTriangularEdge[j][0]])
					<< " , " 
					<< Number(triangles[i][VerticesOfTriangularEdge[j][1]])
					<< " ) is in more than 2 triangles " <<k <<endl;
				 cerr << " Edge " << j << " Of Triangle " << i << endl;
				 cerr << " Edge " << (-st[k]+2)%3 << " Of Triangle " << (-st[k]+2)/3  << endl;
				 cerr << " Edge " << triangles[(-st[k]+2)/3].NuEdgeTriangleAdj((int)((-st[k]+2)%3))
					<< " Of Triangle " <<  Number(triangles[(-st[k]+2)/3].TriangleAdj((int)((-st[k]+2)%3))) 
					<< endl;
				 MeshError(9999);}	


			}
		Int4 nbedges = edge4->nb(); // the total number of edges 
		delete edge4;
		edge4 =0;

		if(verbosity>5) {
			if (name)
			 cout << "    On Mesh " << name << endl;
			cout << "    - The number of Vertices  = " << nbv << endl;
			cout << "    - The number of Triangles = " << nbt << endl;
			cout << "    - The number of given edge = " << nbe << endl;
			cout << "    - The number of all edges = " << nbedges << endl;
			cout << "    - The Euler number = 1-Nb Of Hole = " << nbt-nbedges+nbv << endl; }


			// check the consistant of edge[].adj and the geometrical required  vertex
			k=0;
			kk=0;
			Int4 it;

			for (i=0;i<nbedges;i++)
			 if (st[i] <-1) // edge internal
				{ 
				 it =  (-2-st[i])/3;
				 j  =  (int) ((-2-st[i])%3);
				 Triangle & tt = * triangles[it].TriangleAdj(j);
				 //cout << it << " c="  << triangles[it].color <<  " " << Number(tt) << " c="  << tt.color << endl;
				 if (triangles[it].color != tt.color|| i < nbeold) // Modif FH 06122055 // between 2 sub domai
				  k++;
				}
			 else if (st[i] >=0) // edge alone 
			  // if (i >= nbeold) 
			  kk++;

			if(verbosity>4 && (k+kk) )
			 cout << "    Nb of  ref edge " << kk+k << " (internal " << k << ")"
				<< " in file " << nbe  << endl;
			k += kk;
			kk=0;
			if (k)
			  {

				//      if (nbe) {
				//	cerr << k << " boundary edges  are not defined as edges " << endl;
				//	MeshError(9998);
				// }
				// construction of the edges 
				nbe = k;
				Edge * edgessave = edges;
				edges = new Edge[nbe];
				k =0;
				// construction of the edges 
				if(verbosity>4)
				 cout << "    Construction of the edges  " << nbe << endl;

				for (i=0;i<nbedges;i++)
				  { 
					Int4  add= -1;

					if (st[i] <-1) // edge internal
					  { 
						it =  (-2-st[i])/3;
						j  =  (int) ((-2-st[i])%3);
						Triangle & tt = * triangles[it].TriangleAdj(j);
						if (triangles[it].color !=  tt.color || i < nbeold) // Modif FH 06122055
						 add=k++;
					  }
					else if (st[i] >=0) // edge alone 
					  {
						it = st[i]/3;
						j  = (int) (st[i]%3);
						add=k++;
					  }

					if (add>=0 && add < nbe)
					  {

						edges[add].v[0] = &triangles[it][VerticesOfTriangularEdge[j][0]];
						edges[add].v[1] = &triangles[it][VerticesOfTriangularEdge[j][1]];
						edges[add].on=0; 
						if (i<nbeold) // in file edge // Modif FH 06122055 
						  {
							edges[add].ref = edgessave[i].ref; 		      
							edges[add].on = edgessave[i].on; //  HACK pour recuperer les aretes requise midf FH avril 2006 ???? 
						  }
						else
						 edges[add].ref = Min(edges[add].v[0]->ref(),edges[add].v[1]->ref()); // no a good choice
					  }
				  }
				assert(k==nbe);
				if (edgessave) delete [] edgessave;
			  }

			// construction of edges[].adj 
			for (i=0;i<nbv;i++) 
			 vertices[i].color =0;
			for (i=0;i<nbe;i++)
			 for (j=0;j<2;j++) 
			  edges[i].v[j]->color++;

			for (i=0;i<nbv;i++) 
			 vertices[i].color = (vertices[i].color ==2) ? -1 : -2;
			for (i=0;i<nbe;i++)
			 for (j=0;j<2;j++) 
				{ 
				 Vertex *v=edges[i].v[j];
				 Int4 i0=v->color,j0;
				 if(i0<0)
				  edges[i ].adj[ j ]=0;  // Add FH Jan 2008   
				 if(i0==-1)
				  v->color=i*2+j;
				 else if (i0>=0) {// i and i0 edge are adjacent by the vertex v
					 j0 =  i0%2;
					 i0 =  i0/2;
					 assert( v ==  edges[i0 ].v[j0]);
					 edges[i ].adj[ j ] =edges +i0;
					 edges[i0].adj[ j0] =edges +i ;
					 assert(edges[i0].v[j0] == v);
					 //	    if(verbosity>8)
					 //  cout << " edges adj " << i0 << " "<< j0 << " <-->  "  << i << " " << j << endl;
					 v->color = -3;}
				}
			// now reconstruct the sub domain info 
			assert(!NbSubDomains);
			NbSubDomains=0;

			  { 
				Int4 it;
				// find all the sub domain
				Int4 *colorT = new Int4[nbt];
				Triangle *tt,*t;
				Int4 k;
				for ( it=0;it<nbt;it++)
				 colorT[it]=-1;
				for (it=0;it<nbt;it++)
				  {
					if (colorT[it]<0) 
					  {
						colorT[it]=NbSubDomains;
						Int4 level =1,j,jt,kolor=triangles[it].color;
						st[0]=it; // stack 
						st[1]=0;
						k=1;
						while (level>0)
						 if( ( j=st[level]++) <3)
							{ 
							 t = &triangles[st[level-1]];
							 tt=t->TriangleAdj((int)j);

							 if ( ! t->Locked(j) && tt && (colorT[jt = Number(tt)] == -1) && ( tt->color==kolor))
								{
								 colorT[jt]=NbSubDomains;
								 st[++level]=jt;
								 st[++level]=0;
								 k++;
								}
							}
						 else 
						  level-=2;
						if (verbosity>5) 
						 cout << "   Nb of triangles " << k << " of Subdomain "  
							<<  NbSubDomains << " " << kolor << endl;
						NbSubDomains++;
					  }
				  }
				if (verbosity> 3)
				 cout << "   The Number of sub domain = " << NbSubDomains << endl;

				Int4 isd;
				subdomains = new SubDomain[NbSubDomains];
				for (isd=0;isd<NbSubDomains;isd++)
				  {
					subdomains[isd].head =0;
				  }
				k=0;
				for (it=0;it<nbt;it++)
				 for (int j=0;j<3;j++)
					{
					 tt=triangles[it].TriangleAdj(j);
					 if ((!tt || tt->color != triangles[it].color) && !subdomains[isd=colorT[it]].head)
						{
						 subdomains[isd].head = triangles+it;
						 subdomains[isd].ref =  triangles[it].color;
						 subdomains[isd].sens = j; // hack
						 subdomains[isd].edge = 0;
						 k++;
						}
					}  
				assert(k== NbSubDomains);

				delete [] colorT;


			  }      
			delete [] st;
			// now make the geometry
			// 1 compress the vertices 
			Int4 * colorV = new Int4[nbv];
			for (i=0;i<nbv;i++) 
			 colorV[i]=-1;
			for (i=0;i<nbe;i++)
			 for ( j=0;j<2;j++)
			  colorV[Number(edges[i][j])]=0;
			k=0;
			for (i=0;i<nbv;i++) 
			 if(!colorV[i])
			  colorV[i]=k++;

			Gh.nbv=k;
			Gh.nbe = nbe;
			Gh.vertices = new GeometricalVertex[k];
			Gh.edges = new GeometricalEdge[nbe];
			Gh.NbSubDomains = NbSubDomains;
			Gh.subdomains = new GeometricalSubDomain[NbSubDomains];
			if (verbosity>3)
			 cout << "    Nb of  vertices  = " << Gh.nbv << " Nb of edges = " << Gh.nbe << endl;
			NbVerticesOnGeomVertex = Gh.nbv;
			VerticesOnGeomVertex = new VertexOnGeom[NbVerticesOnGeomVertex];
			NbVerticesOnGeomEdge =0;
			VerticesOnGeomEdge =0;
			  {
				Int4 j;
				for (i=0;i<nbv;i++) 
				 if((j=colorV[i])>=0)
					{

					 Vertex & v = Gh.vertices[j];
					 v = vertices[i];
					 v.color =0;
					 VerticesOnGeomVertex[j] = VertexOnGeom(vertices[i], Gh.vertices[j]);
					}

			  }
			edge4= new SetOfEdges4(nbe,nbv);  

			Real4 * len = new Real4[Gh.nbv];
			for(i=0;i<Gh.nbv;i++)
			 len[i]=0;

			Gh.pmin =  Gh.vertices[0].r;
			Gh.pmax =  Gh.vertices[0].r;
			// recherche des extrema des vertices pmin,pmax
			for (i=0;i<Gh.nbv;i++) {
				Gh.pmin.x = Min(Gh.pmin.x,Gh.vertices[i].r.x);
				Gh.pmin.y = Min(Gh.pmin.y,Gh.vertices[i].r.y);
				Gh.pmax.x = Max(Gh.pmax.x,Gh.vertices[i].r.x);
				Gh.pmax.y = Max(Gh.pmax.y,Gh.vertices[i].r.y);
			}

			R2 DD05 = (Gh.pmax-Gh.pmin)*0.05;
			Gh.pmin -=  DD05;
			Gh.pmax +=  DD05;

			Gh.coefIcoor= (MaxICoor)/(Max(Gh.pmax.x-Gh.pmin.x,Gh.pmax.y-Gh.pmin.y));
			assert(Gh.coefIcoor >0);

			Real8 hmin = HUGE_VAL;
			int kreq=0;
			for (i=0;i<nbe;i++)
			  {
				Int4 i0 = Number(edges[i][0]);
				Int4 i1 = Number(edges[i][1]);
				Int4 j0 =	 colorV[i0];
				Int4 j1 =  colorV[i1];

				Gh.edges[i].v[0] = Gh.vertices +  j0;
				Gh.edges[i].v[1] = Gh.vertices +  j1;
				Gh.edges[i].flag = 0;
				Gh.edges[i].tg[0]=R2();
				Gh.edges[i].tg[1]=R2();
				bool requis= edges[i].on; 
				if(requis) kreq++;
				edges[i].on =  Gh.edges + i;
				if(equiedges && i < nbeold ) {
					int j=equiedges[i]/2;
					int sens=equiedges[i]%2;
					if(i!=j && equiedges[i]>=0) {
						if(verbosity>9)  
						 cout << " Edges Equi " << i << " <=> " << j << " sens = " << sens  << endl;
						if( sens==0)
						 Gh.edges[i].SetEqui();
						else 
						 Gh.edges[i].SetReverseEqui();
						Gh.edges[i].link= & Gh.edges[j];
						//assert(sens==0);//  meme sens pour l'instant
					}

				}
				if(requis)  {  // correction fevr 2009 JYU ...
					Gh.edges[i].v[0]->SetRequired();
					Gh.edges[i].v[1]->SetRequired();
					Gh.edges[i].SetRequired(); // fin modif ... 
				}
				R2 x12 = Gh.vertices[j0].r-Gh.vertices[j1].r;
				Real8 l12=Norme2(x12);        
				hmin = Min(hmin,l12);

				Gh.vertices[j1].color++;
				Gh.vertices[j0].color++;

				len[j0]+= l12;
				len[j1] += l12;
				hmin = Min(hmin,l12);

				Gh.edges[i].ref  = edges[i].ref;

				k = edge4->addtrie(i0,i1);

				assert(k == i);

			  }


			for (i=0;i<Gh.nbv;i++) 
			 if (Gh.vertices[i].color > 0) 
			  Gh.vertices[i].m=  Metric(len[i] /(Real4) Gh.vertices[i].color);
			 else 
			  Gh.vertices[i].m=  Metric(hmin);
			delete [] len;
			for (i=0;i<NbSubDomains;i++)
			  {
				Int4 it = Number(subdomains[i].head);
				int j = subdomains[i].sens;
				Int4 i0 = Number(triangles[it][VerticesOfTriangularEdge[j][0]]);
				Int4 i1 = Number(triangles[it][VerticesOfTriangularEdge[j][1]]);
				k = edge4->findtrie(i0,i1);
				if(k>=0)
				  {
					subdomains[i].sens = (vertices + i0 == edges[k].v[0]) ? 1 : -1;
					subdomains[i].edge = edges+k;
					Gh.subdomains[i].edge = Gh.edges + k;
					Gh.subdomains[i].sens  =  subdomains[i].sens;
					Gh.subdomains[i].ref =  subdomains[i].ref;
				  }
				else
				 MeshError(103);
			  }

			delete edge4;
			delete [] colorV;
			//  -- unset adj
			for (i=0;i<nbt;i++)
			 for ( j=0;j<3;j++)
			  triangles[i].SetAdj2(j,0,triangles[i].GetAllflag(j));

	  }
	/*}}}1*/

} // end of namespace bamg 
