#!/bin/bash
set -eu


# Constants
#
export PREFIX="install"

# Cleanup
rm -rf ${PREFIX}
mkdir ${PREFIX} ${PREFIX}/include ${PREFIX}/lib src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/triangle.zip" "triangle.zip"

# Unpack source
unzip triangle.zip -d src

# Copy customized source files to 'src' directory
cp configs/makefile src
cp configs/linux/configure.make src

# Patch source
patch src/triangle.c < configs/triangle.c.patch
patch src/triangle.h < configs/triangle.h.patch

# Compile
cd src
make shared

# Install
cd ..
cp src/libtriangle.* ${PREFIX}/lib
cp src/triangle.h ${PREFIX}/include

# Cleanup
rm -rf src
