%Test Name: SquareSheetConstrainedSmbGradients2d
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setflowequation(md,'SSA','all');
md.smb = SMBgradients();
md.smb.b_pos=(-100. + 0.00005*md.mesh.x - 0.0001*md.mesh.y) / 1000. * md.materials.rho_freshwater / md.materials.rho_ice;
md.smb.b_neg=(250. + 0.000051*md.mesh.x - 0.00011*md.mesh.y) / 1000. * md.materials.rho_freshwater / md.materials.rho_ice;
md.smb.href=md.geometry.surface;
md.smb.smbref= (1000. - 0.001*md.mesh.x - 0.005*md.mesh.y) / 1000. * md.materials.rho_freshwater / md.materials.rho_ice;
md.transient.requested_outputs={'default','TotalSmb'};
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Bed1','Surface1','Thickness1','SMB1','TotalSmb1','Vx2','Vy2','Vel2','Bed2','Surface2','Thickness2','SMB2','TotalSmb2','Vx3','Vy3','Vel3','Bed3','Surface3','Thickness3','SMB3','TotalSmb3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,2e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).SmbMassBalance),...
	(md.results.TransientSolution(1).TotalSmb),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).TotalSmb),...
	(md.results.TransientSolution(2).SmbMassBalance),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).SmbMassBalance),...
	(md.results.TransientSolution(3).TotalSmb),...
	};
