function [data isongrid]=processdata(md,data,options_structure);
%PROCESSDATA - process data to be plotted
%
%   Usage:
%      [data isongrid]=processdata(md,data,options_structure);
%
%   See also: PLOTMODEL, PROCESSMESH

%check format
if (iscell(data) | isempty(data)),
	error('plotmodel error message: data provided is empty');
end

%check length
if length(data)~=md.numberofgrids & length(data)~=md.numberofelements & length(data)~=md.numberofgrids*6 & (strcmpi(md.type,'2d') | length(data)~=md.numberofgrids2d)
	error('plotmodel error message: data not supproted yet')
end

%treat the case length(data)=6*grids
if length(data)==6*md.numberofgrids
	%keep the only norm of data
	data1=data(1:6:md.numberofgrids*6);
	data2=data(2:6:md.numberofgrids*6);
	data=sqrt(data1.^2+data2.^2);
	%---> go to grid data
end

%treat the case length(data)=grids2d
if (strcmpi(md.type,'3d') & length(data)==md.numberofgrids2d),
	data=project3d(md,data,'node');
	%---> go to grid data
end

%smoothing?
if ~isnan(options_structure.smooth)
	data=averaging(md,data,options_structure.smooth);
	%---> go to grid data
end

%element data
if length(data)==md.numberofelements;
	isongrid=0;

	%ice sheet only?
	if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
		data(find(md.elementoniceshelf))=NaN;
	end
	%ice shelf only?
	if ~isnan(options_structure.noicesheet) & options_structure.noicesheet,
		data(find(~md.elementoniceshelf))=NaN;
	end
end

%grid data
if length(data)==md.numberofgrids
	isongrid=1;
	%ice sheet only?
	if ~isnan(options_structure.noiceshelf) & options_structure.noiceshelf,
		pos=find(md.gridoniceshelf);
		data(pos)=NaN;
	end
	%ice shelf only?
	if ~isnan(options_structure.noiceshelf) & options_structure.noicesheet,
		pos=find(md.gridonicesheet);
		data(pos)=NaN;
	end
end

%layer projection? 
if ~isnan(options_structure.layer) & options_structure.layer>=1,
	data=project2d(md,data,options_structure.layer); %project onto 2d mesh
end
