function plotmodel(md,varargin)
%At command prompt, type plotdoc for help on documentation.

global ISSM_DIR
if isempty(ISSM_DIR),
	error('ISSM_DIR variable got erased! This variable is needed to run Ice code correctly. Please rerun your startup file.');
end

%First go through varargin and  figure out how many subplots we are going to make
datavalues=findarg(varargin,'data');
numberofplots=length(datavalues);
subplotwidth=ceil(sqrt(numberofplots));

%Get figure number 
figurevalues=findarg(varargin,'figure');
if ~isempty(figurevalues),
	if length(figurevalues)>1,
		error('plotmodel error message: only one figure allowed');
	else
		figurenumber=figurevalues.value;
	end
else
	figurenumber=1;
end

%go through subplots
if numberofplots,
		
	%recover options  for all subplots.
	options=recover_plot_options(md,varargin,numberofplots);
	
	%Create figure 
	figure(figurenumber),clf;

	%Go through all data plottable
	for i=1:numberofplots,

		%call unit plot
		plot_dealer(md,options{i},subplotwidth,i);

	end
else
	error('plotmodel error message: no output data found. ');
end
