function plot_unit(x,y,z,elements,data,isongrid,is2d,options_structure)
%PLOT_UNIT - unit plot, display data
%
%   Usage:
%      plot_unit(x,y,z,elements,data,isongrid,is2d,options_structure);
%
%   See also: PLOTMODEL, PLOT_DEALER

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%element data
if ~isongrid
	if is2d
		A=elements(:,1); B=elements(:,2); C=elements(:,3); 
		patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
	else
		A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
		patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
		patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', data(:),'FaceColor','flat','EdgeColor',edgecolor);
	end
%grid data
elseif isongrid
	if is2d
		A=elements(:,1); B=elements(:,2); C=elements(:,3); 
		patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
	else
		if options_structure.layer>=1,
			A=elements(:,1); B=elements(:,2); C=elements(:,3); 
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
		else
			A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
		end
	end
end
