function plot_transient_movie(md,options_structure,width,i);
%PLOT_TRANSIENT_MOVIE - plot a transient result as a movie
%   Usage:
%      plot_transient_movie(md,options_structure,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_DEALER

	%prepare subplot
	subplot(width,width,i); 

	if strcmpi(md.type,'2d') 
		choice=input('Which field do you want to plot? (vel/vx/vy/thickness/surface/bed)','s');
		if ~strcmp(choice,'vel') & ~strcmp(choice,'vx') & ~strcmp(choice,'vy') & ~strcmp(choice,'thickness') & ~strcmp(choice,'bed') & ~strcmp(choice,'surface')
			disp('plot_transient_movie error message: input not supported yet, exiting...')
			return
		end
	else
		choice=input('Which field do you want to plot? (vel/vx/vy/vz/thickness/surface/bed/temperature)','s');
		if ~strcmp(choice,'vel') & ~strcmp(choice,'vx') & ~strcmp(choice,'vy') & ~strcmp(choice,'vz') & ~strcmp(choice,'temperature') & ~strcmp(choice,'thickness') & ~strcmp(choice,'bed') & ~strcmp(choice,'surface')
			disp('plot_transient_movie error message: input not supported yet, exiting...')
			return
		end
	end

	%process model
	[x y z elements is2d]=processmesh(md,options_structure);

	%loop over the time steps
	for i=1:length(md.transient_results)
		eval(['data=md.transient_results(' num2str(i) ').' num2str(choice) ';']);

		%process data
		[data isongrid]=processdata(md,data,options_structure);
		titlestring=[choice ' at time ' num2str(md.transient_results(i).time) ' year'];
		plot_unit(x,y,z,elements,data,isongrid,is2d,options_structure)
		apply_options_movie(md,options_structure,titlestring);
		pause(0.5)
	end
end %function

function apply_options_movie(md,options_structure,titlestring)
	%apply options
	if isnan(options_structure.title)
		options_structure.title=titlestring;
	end 
	if isnan(options_structure.colorbar)
		options_structure.colorbar=1;
	end
	applyoptions(md,[],options_structure);
end
