function plot_tensor_principalaxis(md,options_structure,width,i,tensor,type,plot_options);
%PLOT_TENSOR_PRINCIPALAXIS - plot ytensor principal axis
%
%   Usage:
%      plot_tensor_principalaxis(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%prepare subplot
subplot(width,width,i); 

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);

if (strcmpi(md.type,'2d')),
	eval(['Vx=tensor.principalaxis' type(end) '(:,1); Vy=tensor.principalaxis' type(end) '(:,2);'])
	eval(['value=tensor.principalvalue' type(end) ';']);
	[Vx isongrid]=processdata(md,Vx,options_structure);
	[Vy isongrid]=processdata(md,Vy,options_structure);
	[value isongrid]=processdata(md,value,options_structure);
else
	eval(['Vx=tensor.principalaxis' type(end) '(:,1); Vy=tensor.principalaxis' type(end) '(:,2); Vz=tensor.principalaxis' type(end) '(:,3);'])
	[Vx isongrid]=processdata(md,Vx,options_structure);
	[Vy isongrid]=processdata(md,Vy,options_structure);
	[Vz isongrid]=processdata(md,Vz,options_structure);
	[value isongrid]=processdata(md,value,options_structure);
end

%take the center of each element if ~isongrid
if ~isongrid
	x=mean(md.x(md.elements'))'; y=mean(md.y(md.elements'))'; z=mean(md.z(md.elements'))';
end

%plot quivers
if strcmpi(md.type,'2d'),

	%density
	if ~isnan(options_structure.density)
		x=x(1:options_structure.density:end);
		y=y(1:options_structure.density:end);
		Vx=Vx(1:options_structure.density:end);
		Vy=Vy(1:options_structure.density:end);
		value=value(1:options_structure.density:end);
	end

	%scaling:
	delta=((min(x)-max(x))^2+(min(y)-max(y))^2)/numel(x);
	scale=0.5/max(sqrt((Vx.^2+Vy.^2)/delta));
	Vx=scale*Vx; Vy=scale*Vy;

	pos=find(value>=0);
	q1=quiver(x(pos),y(pos),Vx(pos),Vy(pos),'Color','r','ShowArrowHead','off','AutoScale','off');
	hold on
	pos=find(value<0);
	q2=quiver(x(pos),y(pos),Vx(pos),Vy(pos),'Color','b','ShowArrowHead','off','AutoScale','off');

else
	%density
	if ~isnan(options_structure.density)
		x=x(1:options_structure.density:end);
		y=y(1:options_structure.density:end);
		z=z(1:options_structure.density:end);
		Vx=Vx(1:options_structure.density:end);
		Vy=Vy(1:options_structure.density:end);
		Vz=Vz(1:options_structure.density:end);
		value=value(1:options_structure.density:end);
	end

	%scaling:
	delta=((min(x)-max(x))^2+(min(y)-max(y))^2)/numel(x);
	scale=0.5/max(sqrt((Vx.^2+Vy.^2)/delta));
	Vx=scale*Vx; Vy=scale*Vy; Vz=scale*Vz;

	pos=find(value>=0);
	q1=quiver3(x(pos),y(pos),z(pos),Vx(pos),Vy(pos),Vz(pos),'Color','r','ShowArrowHead','off','AutoScale','off');
	hold on
	pos=find(value<0);
	q2=quiver3(x(pos),y(pos),z(pos),Vx(pos),Vy(pos),Vz(pos),'Color','b','ShowArrowHead','off','AutoScale','off');
end

%legend
if strcmpi(type(1:6),'strain')
	legend([q1 q2],'extension','compression')
elseif strcmpi(type(1:6),'stress')
	legend([q1 q2],'compression','traction')
end

%apply options
if isnan(options_structure.title)
	strings=strsplit(type,'_');
	string=strings{1};
	options_structure.title=[upper(string(1)) string(2:end) ' principal axis ' type(end)];
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
