function plot_quivervel3(md,options_structure,width,i);
%PLOT_QUIVERVEL3 - plot arrow field of 3d velocities
%
%   Usage:
%      plot_quivervel3(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[vx isongrid]=processdata(md,md.vx,options_structure);
[vy isongrid]=processdata(md,md.vy,options_structure);
[vz isongrid]=processdata(md,md.vz,options_structure);

%plot mesh quivervel3
subplot(width,width,i); 

%quiver 3d 
if ~isnan(options_structure.density)
	x=x(1:options_structure.density:end);
	y=y(1:options_structure.density:end);
	z=z(1:options_structure.density:end);
	vx=vx(1:options_structure.density:end);
	vy=vy(1:options_structure.density:end);
	vz=vz(1:options_structure.density:end);
end
quiver3(x,y,z,vx,vy,vz);

%apply options
if isnan(options_structure.title)
	options_structure.title='Velocity vectors (3D)';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=1;
end
applyoptions(md,[],options_structure);
