function plot_penalties(md,options_structure,width,i);
%PLOT_PENALTIES - plot penalties
%
%   Usage:
%      plot_penalties(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);

%plot mesh penalties
subplot(width,width,i); 

%units
if ~isnan(options_structure.unitmultiplier),
	x=x*options_structure.unitmultiplier;
	y=y*options_structure.unitmultiplier;
	z=z*options_structure.unitmultiplier;
end

if ~strcmpi(md.type,'3d'),
	error('no penalties to plot for ''2d'' model');
elseif isempty(md.penalties),
	disp('no penalty applied in this model');
	return;
else
	%plot mesh
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');

	hold on;
	for (i=1:size(md.penalties,1)),
		P1=plot3(x(md.penalties(i,1)),y(md.penalties(i,1)),z(md.penalties(i,1)),'ro','MarkerSize',15,'MarkerFaceColor','r');
		P2=plot3(x(md.penalties(i,:)),y(md.penalties(i,:)),z(md.penalties(i,:)),'bo-','LineWidth',2,'MarkerSize',8,'MarkerFaceColor','b');
	end
	legend([P1 P2],'MacAyeal''s penalized grids','Pattyn''s penalized grids');
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Penalties';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
