function plot_drivingstress(md,options_structure,width,i);
%PLOT_DRIVINGSTRESS - plot driving stress
%
%   Usage:
%      plot_drivingstress(md,options_structure,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_DEALER

%get driving stress
[sx sy s]=drivingstress(md);

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[dstress isongrid]=processdata(md,s,options_structure);
dstress=dstress/1000;

%plot mesh quivervel
subplot(width,width,i); 
plot_unit(x,y,z,elements,dstress,isongrid,is2d,options_structure)

%apply options
if isnan(options_structure.title)
	options_structure.title='Driving stress [kPa]';
end 
if isnan(options_structure.view)
	options_structure.view=2;
end 
applyoptions(md,dstress,options_structure);
