function plot_boundaries(md,options_structure,width,i);
%PLOT_BOUNDARIES - plot mesh boundaries
%
%   Usage:
%      plot_boundaries(md,options_structure,width,i);
%
%   See also: PLOTMODEL

subplot(width,width,i); 

%process data and model
if ~isnan(options_structure.layer)
	disp('plotmodel warning: layer projection not supported yet by plot_boundaries');
	options_structure.layer=NaN;
end
[x y z elements is2d]=processmesh(md,options_structure);

for i=1:size(md.segments,1),
	plot(x(md.segments(i,1:2)),y(md.segments(i,1:2)),'k.-');hold on;
end

%plot rifts if present: 
if isstruct(md.rifts),
	for i=1:size(md.rifts,1),
		segments=md.rifts(i).segments;
		for j=1:size(segments,1),
			plot(x(segments(j,1:2)),y(segments(j,1:2)),'r.-');
		end
		text(x(segments(floor(size(segments,1)/4),1)),y(segments(floor(size(segments,1)/4),1)),['Rift #' num2str(i)]);
		%point out the tips
		plot(x(md.rifts(i).tips(1)),y(md.rifts(i).tips(1)),'b*');
		plot(x(md.rifts(i).tips(2)),y(md.rifts(i).tips(2)),'b*');
	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Mesh boundaries';
end
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
if isnan(options_structure.view)
	options_structure.view=2;
end
applyoptions(md,[],options_structure);
