function displayqmu(md)
%DISPLAYQMU - display qmu computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   qmu computation from model md, only if requested.
%
%   Usage:
%      displayqmu(md)

disp(sprintf('      ''%s''','qmu using Dakota'));

disp(sprintf('         variables:  (arrays of each variable class)'));
fnames=fieldnames(md.variables);
for i=1:length(fnames);
    disp(sprintf('            %s    [%ix%i]    ''%s''',...
        fnames{i},size(md.variables.(fnames{i})),class(md.variables.(fnames{i}))));
end

disp(sprintf('         responses:  (arrays of each response class)'));
fnames=fieldnames(md.responses);
for i=1:length(fnames);
    disp(sprintf('            %s    [%ix%i]    ''%s''',...
        fnames{i},size(md.responses.(fnames{i})),class(md.responses.(fnames{i}))));
end

disp(sprintf('         qmu_method:  (array of dakota_method class)'));
for i=1:numel(md.qmu_method);
    if strcmp(class(md.qmu_method(i)),'dakota_method')
        disp(sprintf('            method%s :    ''%s''',...
            string_dim(md.qmu_method,i),md.qmu_method(i).method));
    end
end

for i=1:numel(md.qmu_params)
    disp(sprintf('         qmu_params%s:  (array of method-independent parameters)',...
        string_dim(md.qmu_params,i)));
    fnames=fieldnames(md.qmu_params(i));
    maxlen=0;
    for j=1:numel(fnames)
        maxlen=max(maxlen,length(fnames{j}));
    end
    
    for j=1:numel(fnames)
        disp(sprintf(['            %-' num2str(maxlen+1) 's: %s'],...
            fnames{j},any2str(md.qmu_params(i).(fnames{j}))));
    end
end

disp(sprintf('         dakotaresults: 1x%i   {dvar,rfunc,scm,pcm,srcm,prcm}',length(md.dakotaresults)));
if isempty(md.dakotain), disp(sprintf('         dakotain: N/A')); else disp(sprintf('         dakotain: not displayed (can be accessed by typing md.dakotain)'));end
if isempty(md.dakotaout), disp(sprintf('         dakotaout: N/A')); else disp(sprintf('         dakotaout: not displayed (can be accessed by typing md.dakotaout)'));end
if isempty(md.dakotadat), disp(sprintf('         dakotadat: N/A')); else disp(sprintf('         dakotadat: not displayed (can be accessed by typing md.dakotadat)'));end
disp(sprintf('         npart   : %i (number of partitions for semi-descrete qmu)',md.npart));
disp(sprintf('         numrifts: %i (number of rifts for semi-descrete qmu)',md.numrifts));
