%
%  definition for the objective_function class.
%
%  [of]=objective_function(varargin)
%
classdef objective_function
    properties
        descriptor='';
        scale_type='none';
        scale     = 1.;
        weight    = 1.;
    end
    
    methods
        function [of]=objective_function(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'objective_function')
                        of=varargin{1};
                    else
                        of.descriptor=varargin{1};

                        if (nargin >= 2)
                            of.scale_type=varargin{2};
                            if (nargin >= 3)
                                of.scale     =varargin{3};
                                if (nargin >= 4)
                                    of.weight    =varargin{4};

                                    if (nargin > 4)
                                        warning('objective_function:extra_arg',...
                                            'Extra arguments for object of class ''%s''.',...
                                            class(of));
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(of)
            desc=cell(size(of));
            for i=1:numel(of)
                desc(i)=cellstr(of(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(of)
            stype=cell(size(of));
            for i=1:numel(of)
                stype(i)=cellstr(of(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(of)
            scale=zeros(size(of));
            for i=1:numel(of)
                scale(i)=of(i).scale;
            end
            scale=allequal(scale,1.);
        end
        function [weight]=prop_weight(of)
            weight=zeros(size(of));
            for i=1:numel(of)
                weight(i)=of(i).weight;
            end
            weight=allequal(weight,1.);
        end
        function [lower] =prop_lower(of)
            lower=[];
        end
        function [upper] =prop_upper(of)
            upper=[];
        end
        function [target]=prop_target(of)
            target=[];
        end
    end
end
