%
%  constructor for the nonlinear_inequality_constraint class.
%
%  [nic]=nonlinear_inequality_constraint(varargin)
%
classdef nonlinear_inequality_constraint
    properties
        descriptor='';
        lower     =-Inf;
        upper     = 0.;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [nic]=nonlinear_inequality_constraint(varargin)

            switch nargin

 %  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'nonlinear_inequality_constraint')
                        nic=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'nonlinear_inequality_constraint');
                    end

%  create the object from the input

                otherwise
                    nic.descriptor=varargin{1};
                    nic.lower     =varargin{2};
                    nic.upper     =varargin{3};

                    if (nargin >= 4)
                        nic.scale_type=varargin{4};
                        if (nargin >= 5)
                            nic.scale     =varargin{5};

                            if (nargin > 5)
                                warning('objective_function:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(nic));
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(nic)
            desc=cell(size(nic));
            for i=1:numel(nic)
                desc(i)=cellstr(nic(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(nic)
            stype=cell(size(nic));
            for i=1:numel(nic)
                stype(i)=cellstr(nic(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(nic)
            scale=zeros(size(nic));
            for i=1:numel(nic)
                scale(i)=nic(i).scale;
            end
            scale=allequal(scale,1.);
        end
        function [weight]=prop_weight(nic)
            weight=[];
        end
        function [lower] =prop_lower(nic)
            lower=zeros(size(nic));
            for i=1:numel(nic)
                lower(i)=nic(i).lower;
            end
            lower=allequal(lower,-Inf);
        end
        function [upper] =prop_upper(nic)
            upper=zeros(size(nic));
            for i=1:numel(nic)
                upper(i)=nic(i).upper;
            end
            upper=allequal(upper,0.);
        end
        function [target]=prop_target(nic)
            target=[];
        end
    end
end
