%
%  constructor for the nonlinear_equality_constraint class.
%
%  [nec]=nonlinear_equality_constraint(varargin)
%
classdef nonlinear_equality_constraint
    properties
        descriptor='';
        target    = 0.;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [nec]=nonlinear_equality_constraint(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'nonlinear_equality_constraint')
                        nec=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'nonlinear_equality_constraint');
                    end

%  create the object from the input

                otherwise
                    nec.descriptor=varargin{1};
                    nec.target    =varargin{2};

                    if (nargin >= 3)
                        nec.scale_type=varargin{3};
                        if (nargin >= 4)
                            nec.scale     =varargin{4};

                            if (nargin > 4)
                                warning('objective_function:extra_arg',...
                                    'Extra arguments for object of class ''%s''.',...
                                    class(nec));
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(nec)
            desc=cell(size(nec));
            for i=1:numel(nec)
                desc(i)=cellstr(nec(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(nec)
            stype=cell(size(nec));
            for i=1:numel(nec)
                stype(i)=cellstr(nec(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(nec)
            scale=zeros(size(nec));
            for i=1:numel(nec)
                scale(i)=nec(i).scale;
            end
            scale=allequal(scale,1.);
        end
        function [weight]=prop_weight(nec)
            weight=[];
        end
        function [lower] =prop_lower(nec)
            lower=[];
        end
        function [upper] =prop_upper(nec)
            upper=[];
        end
        function [target]=prop_target(nec)
            target=zeros(size(nec));
            for i=1:numel(nec)
                target(i)=nec(i).target;
            end
            target=allequal(target,0.);
        end
    end
end
