%
%  constructor for the linear_inequality_constraint class.
%
%  [lic]=linear_inequality_constraint(varargin)
%
classdef linear_inequality_constraint
    properties
        matrix    = NaN;
        lower     =-Inf;
        upper     = 0.;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [lic]=linear_inequality_constraint(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'linear_inequality_constraint')
                        lic=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'linear_inequality_constraint');
                    end

%  create the object from the input

                otherwise
                    if (size(varargin{1},1) > 1)
                        warning('linear_inequality_constraint:matrix_rows',...
                            'Matrix for object of class ''%s'' has %d rows.',...
                            class(lic),size(varargin{1},1));
                    end
                    lic.matrix    =varargin{1}(1,:);

                    if (nargin >= 2)
                        lic.lower     =varargin{2};
                        if (nargin >= 3)
                            lic.upper     =varargin{3};
                            if (nargin >= 4)
                                lic.scale_type=varargin{4};
                                if (nargin >= 5)
                                    lic.scale     =varargin{5};

                                    if (nargin > 5)
                                        warning('linear_inequality_constraint:extra_arg',...
                                            'Extra arguments for object of class ''%s''.',...
                                            class(lic));
                                    end
                                end
                            end
                        end
                    end
            end
        end

        function [matrix]=prop_matrix(lic)
            matrix=zeros(numel(lic),0);
            for i=1:numel(lic)
                matrix(i,1:size(lic(i).matrix,2))=lic(i).matrix(1,:);
            end
        end
        function [lower] =prop_lower(lic)
            lower=zeros(size(lic));
            for i=1:numel(lic)
                lower(i)=lic(i).lower;
            end
            lower=allequal(lower,-Inf);
        end
        function [upper] =prop_upper(lic)
            upper=zeros(size(lic));
            for i=1:numel(lic)
                upper(i)=lic(i).upper;
            end
            upper=allequal(upper,0.);
        end
        function [target]=prop_target(lic)
            target=[];
        end
        function [stype] =prop_stype(lic)
            stype=cell(size(lic));
            for i=1:numel(lic)
                stype(i)=cellstr(lic(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(lic)
            scale=zeros(size(lic));
            for i=1:numel(lic)
                scale(i)=lic(i).scale;
            end
            scale=allequal(scale,1.);
        end
    end
end

