%
%  display for the linear_inequality_constraint class.
%
%  []=display(lic)
%
function []=display(lic)

if ~isa(lic,'linear_inequality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lic),'linear_inequality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lic)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lic),inputname(1),string_dim(lic,i)));
    disp(sprintf('        matrix: %s'      ,string_vec(lic(i).matrix)));
    disp(sprintf('         lower: %g'      ,lic(i).lower));
    disp(sprintf('         upper: %g'      ,lic(i).upper));
    disp(sprintf('    scale_type: ''%s'''  ,lic(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,lic(i).scale));
end

end

