%
%  constructor for the linear_equality_constraint class.
%
%  [lec]=linear_equality_constraint(varargin)
%
classdef linear_equality_constraint
    properties
        matrix    = NaN;
        target    = 0.;
        scale_type='none';
        scale     = 1.;
    end
    
    methods
        function [lec]=linear_equality_constraint(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object

                case 1
                    if isa(varargin{1},'linear_equality_constraint')
                        lec=varargin{1};
                    else
                        error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
                            inputname(1),class(varargin{1}),'linear_equality_constraint');
                    end

%  create the object from the input

                otherwise
                    if (size(varargin{1},1) > 1)
                        warning('linear_equality_constraint:matrix_rows',...
                            'Matrix for object of class ''%s'' has %d rows.',...
                            class(lec),size(varargin{1},1));
                    end
                    lec.matrix    =varargin{1}(1,:);

                    if (nargin >= 2)
                        lec.target    =varargin{2};
                        if (nargin >= 3)
                            lec.scale_type=varargin{3};
                            if (nargin >= 4)
                                lec.scale     =varargin{4};

                                if (nargin > 4)
                                    warning('linear_equality_constraint:extra_arg',...
                                        'Extra arguments for object of class ''%s''.',...
                                        class(lec));
                                end
                            end
                        end
                    end
            end
        end

        function [matrix]=prop_matrix(lec)
            matrix=zeros(numel(lec),0);
            for i=1:numel(lec)
                matrix(i,1:size(lec(i).matrix,2))=lec(i).matrix(1,:);
            end
        end
        function [lower] =prop_lower(lec)
            lower=[];
        end
        function [upper] =prop_upper(lec)
            upper=[];
        end
        function [target]=prop_target(lec)
            target=zeros(size(lec));
            for i=1:numel(lec)
                target(i)=lec(i).target;
            end
            target=allequal(target,0.);
        end
        function [stype] =prop_stype(lec)
            stype=cell(size(lec));
            for i=1:numel(lec)
                stype(i)=cellstr(lec(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(lec)
            scale=zeros(size(lec));
            for i=1:numel(lec)
                scale(i)=lec(i).scale;
            end
            scale=allequal(scale,1.);
        end
    end
end
