%
%  display for the linear_equality_constraint class.
%
%  []=display(lec)
%
function []=display(lec)

if ~isa(lec,'linear_equality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(lec),'linear_equality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(lec)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(lec),inputname(1),string_dim(lec,i)));
    disp(sprintf('        matrix: %s'      ,string_vec(lec(i).matrix)));
    disp(sprintf('        target: %g'      ,lec(i).target));
    disp(sprintf('    scale_type: ''%s'''  ,lec(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,lec(i).scale));
end

end

