%
%  definition for the least_squares_term class.
%
%  [lst]=least_squares_term(varargin)
%
classdef least_squares_term
    properties
        descriptor='';
        scale_type='none';
        scale     = 1.;
        weight    = 1.;
    end
    
    methods
        function [lst]=least_squares_term(varargin)

            switch nargin

%  create a default object

                case 0

%  copy the object or create the object from the input

                otherwise
                    if  (nargin == 1) && isa(varargin{1},'least_squares_term')
                        lst=varargin{1};
                    else
                        lst.descriptor=varargin{1};

                        if (nargin >= 2)
                            lst.scale_type=varargin{2};
                            if (nargin >= 3)
                                lst.scale     =varargin{3};
                                if (nargin >= 4)
                                    lst.weight    =varargin{4};

                                    if (nargin > 4)
                                        warning('objective_function:extra_arg',...
                                            'Extra arguments for object of class ''%s''.',...
                                            class(lst));
                                    end
                                end
                            end
                        end
                    end
            end

        end
        function [desc]  =prop_desc(lst)
            desc=cell(size(lst));
            for i=1:numel(lst)
                desc(i)=cellstr(lst(i).descriptor);
            end
            desc=allempty(desc);
        end
        function [stype] =prop_stype(lst)
            stype=cell(size(lst));
            for i=1:numel(lst)
                stype(i)=cellstr(lst(i).scale_type);
            end
            stype=allequal(stype,'none');
        end
        function [scale] =prop_scale(lst)
            scale=zeros(size(lst));
            for i=1:numel(lst)
                scale(i)=lst(i).scale;
            end
            scale=allequal(scale,1.);
        end
        function [weight]=prop_weight(lst)
            weight=zeros(size(lst));
            for i=1:numel(lst)
                weight(i)=lst(i).weight;
            end
            weight=allequal(weight,1.);
        end
        function [lower] =prop_lower(lst)
            lower=[];
        end
        function [upper] =prop_upper(lst)
            upper=[];
        end
        function [target]=prop_target(lst)
            target=[];
        end
    end
end
