// -*- Mode : c++ -*-
//
// SUMMARY  :      
// USAGE    :        
// ORG      : 
// AUTHOR   : Frederic Hecht
// E-MAIL   : hecht@ann.jussieu.fr
//

/*
 
 This file is part of Freefem++
 
 Freefem++ is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 2.1 of the License, or
 (at your option) any later version.
 
 Freefem++  is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License
 along with Freefem++; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <cstdio>
#include <iostream>
#include <fstream>
#include "error.hpp"
#include <cstring>
#include <cstdlib>
#include <cctype>
using namespace std;
//  PB compilo HP aCC 
#if defined(__hpux) || defined(__SUNPRO_CC) 
#define IOS_OPENMODE int
#else
#define IOS_OPENMODE ios::openmode
#endif

namespace bamg {


extern  void (*MeshIstreamErrorHandler)(ios & );

void WriteStr(ostream & out,char * str);

union Char4orLong {  char c[4];    long l;} ;

class  MeshIstream {
public:
  istream  & in ;
  const char * CurrentFile;
  //  ifstream  fin;
  int LineNumber,LineError,opened;


  istream & cm ()//  mange les blancs et les commentaire 
  { 
    char c;
    int cmm=0;
    while ( in.get(c) &&  
	    ( isspace(c) ?
	      (( ( c=='\n'|| c==char(12) || c==char(15)) && (LineNumber++,cmm=0)),1) 
	      : (cmm || (c=='#' && (cmm=1) )) ) 
	    ) ((void ) 0);
	   if (in.good()) in.putback(c);
    return in;
  }

  // void rewind(){ fin.clear();fin.seekg(0);}
    
  void eol()// go to end of line
  { 
    char c;
    while ( in.get(c) &&  ( c!='\n') && ( c!='\r')) (void) 0;
  }
  void ShowIoErr(int );
  MeshIstream  & err () 
  { 
    if ( ! in.good() ) ShowIoErr(in.rdstate());
    return *this;
  }
  //  MeshIstream(istream & i): in(i),CurrentFile(0),LineNumber(1),LineError(0) {}

  MeshIstream(const char * file_name)
    : in(*new ifstream(file_name)),CurrentFile(file_name), LineNumber(1),LineError(0) 
  {    if (!in) {cerr << " Error Opening file " << file_name,CurrentFile=0;ShowIoErr(1);}
  err();  }

  /*  //  void close()
  {
      if (CurrentFile) {
        if(verbosity>5) cout << "    Closefile: " <<  CurrentFile << endl;
	CurrentFile=0;in.close();}
  } */
  int eof(){return in.eof();}
  ~MeshIstream(){delete &in;}
  int IsString(const char* s);
  char * ReadStr();
  MeshIstream&   operator>>(short& i)   { cm() >> i ;return err();}
  MeshIstream&   operator>>(long& i)   { cm() >> i ;return err();}
  MeshIstream&   operator>>(int& i)   { cm() >> i ;return err();}
  MeshIstream&   operator>>(float& i)   { cm() >> i ;return err();}
  MeshIstream&   operator>>(double& i)   { cm() >> i ;return err();}
  MeshIstream&   operator>>(char * & i ) { i=ReadStr();return err();}

};

/// ---------- inline -------------------------

}
